/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.security;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.apache.ignite.plugin.security.SecuritySubject;

public class GridSecurityContext
implements SecurityContext,
Externalizable {
    private static final long serialVersionUID = 0L;
    private SecuritySubject subj;
    private Map<String, Collection<SecurityPermission>> strictTaskPerms = new LinkedHashMap<String, Collection<SecurityPermission>>();
    private Map<String, Collection<SecurityPermission>> wildcardTaskPerms = new LinkedHashMap<String, Collection<SecurityPermission>>();
    private Map<String, Collection<SecurityPermission>> strictSrvcPerms = new LinkedHashMap<String, Collection<SecurityPermission>>();
    private Map<String, Collection<SecurityPermission>> wildcardSrvcPerms = new LinkedHashMap<String, Collection<SecurityPermission>>();
    private Map<String, Collection<SecurityPermission>> strictCachePerms = new LinkedHashMap<String, Collection<SecurityPermission>>();
    private Map<String, Collection<SecurityPermission>> wildcardCachePerms = new LinkedHashMap<String, Collection<SecurityPermission>>();
    private Collection<SecurityPermission> tracingPerms = new LinkedHashSet<SecurityPermission>();
    private Collection<SecurityPermission> sysPerms;

    public GridSecurityContext() {
    }

    public GridSecurityContext(SecuritySubject subj) {
        this.subj = subj;
        this.initRules();
    }

    @Override
    public SecuritySubject subject() {
        return this.subj;
    }

    @Override
    public boolean taskOperationAllowed(String taskClsName, SecurityPermission perm) {
        assert (perm == SecurityPermission.TASK_EXECUTE || perm == SecurityPermission.TASK_CANCEL) : perm;
        Collection<SecurityPermission> p = this.strictTaskPerms.get(taskClsName);
        if (p != null) {
            return p.contains((Object)perm);
        }
        for (Map.Entry<String, Collection<SecurityPermission>> entry : this.wildcardTaskPerms.entrySet()) {
            if (!taskClsName.startsWith(entry.getKey())) continue;
            return entry.getValue().contains((Object)perm);
        }
        return this.subj.permissions().defaultAllowAll();
    }

    @Override
    public boolean cacheOperationAllowed(String cacheName, SecurityPermission perm) {
        assert (perm == SecurityPermission.CACHE_PUT || perm == SecurityPermission.CACHE_READ || perm == SecurityPermission.CACHE_REMOVE || perm == SecurityPermission.CACHE_CREATE || perm == SecurityPermission.CACHE_DESTROY) : perm;
        Collection<SecurityPermission> p = this.strictCachePerms.get(cacheName);
        if (p != null) {
            return p.contains((Object)perm);
        }
        for (Map.Entry<String, Collection<SecurityPermission>> entry : this.wildcardCachePerms.entrySet()) {
            if (!(cacheName != null ? cacheName.startsWith(entry.getKey()) : entry.getKey().isEmpty())) continue;
            return entry.getValue().contains((Object)perm);
        }
        return this.subj.permissions().defaultAllowAll();
    }

    @Override
    public boolean serviceOperationAllowed(String srvcName, SecurityPermission perm) {
        assert (perm == SecurityPermission.SERVICE_DEPLOY || perm == SecurityPermission.SERVICE_CANCEL || perm == SecurityPermission.SERVICE_INVOKE) : perm;
        assert (srvcName != null);
        Collection<SecurityPermission> p = this.strictSrvcPerms.get(srvcName);
        if (p != null) {
            return p.contains((Object)perm);
        }
        for (Map.Entry<String, Collection<SecurityPermission>> entry : this.wildcardSrvcPerms.entrySet()) {
            if (!srvcName.startsWith(entry.getKey())) continue;
            return entry.getValue().contains((Object)perm);
        }
        return this.subj.permissions().defaultAllowAll();
    }

    @Override
    public boolean tracingOperationAllowed(SecurityPermission perm) {
        assert (perm == SecurityPermission.TRACING_CONFIGURATION_UPDATE) : perm;
        if (F.isEmpty(this.tracingPerms)) {
            return this.subj.permissions().defaultAllowAll();
        }
        return this.tracingPerms.contains((Object)perm);
    }

    @Override
    public boolean systemOperationAllowed(SecurityPermission perm) {
        assert (perm == SecurityPermission.EVENTS_ENABLE || perm == SecurityPermission.EVENTS_DISABLE || perm == SecurityPermission.ADMIN_VIEW || perm == SecurityPermission.ADMIN_CACHE || perm == SecurityPermission.ADMIN_QUERY || perm == SecurityPermission.ADMIN_OPS || perm == SecurityPermission.CACHE_DESTROY || perm == SecurityPermission.CACHE_CREATE || perm == SecurityPermission.JOIN_AS_SERVER || perm == SecurityPermission.CHANGE_SNAPSHOT_SECURITY_LEVEL || perm == SecurityPermission.SET_QUERY_MEMORY_QUOTA || perm == SecurityPermission.GET_QUERY_VIEWS || perm == SecurityPermission.KILL_QUERY || perm == SecurityPermission.ADMIN_METADATA_OPS || perm == SecurityPermission.ADMIN_READ_DISTRIBUTED_PROPERTY || perm == SecurityPermission.ADMIN_WRITE_DISTRIBUTED_PROPERTY || perm == SecurityPermission.REFRESH_STATISTICS || perm == SecurityPermission.CHANGE_STATISTICS);
        boolean legacyEmptySysPerms = IgniteSystemProperties.getBoolean("IGNITE_DFLT_ALLOW_EMPTY_SYS_PERMISSIONS");
        if (legacyEmptySysPerms ? this.sysPerms == null : F.isEmpty(this.sysPerms)) {
            return this.subj.permissions().defaultAllowAll();
        }
        boolean ret = this.sysPerms.contains((Object)perm);
        if (!(ret || perm != SecurityPermission.EVENTS_ENABLE && perm != SecurityPermission.EVENTS_DISABLE)) {
            ret = this.sysPerms.contains((Object)SecurityPermission.ADMIN_VIEW) || this.sysPerms.contains((Object)SecurityPermission.ADMIN_OPS) || this.sysPerms.contains((Object)SecurityPermission.ADMIN_CACHE) || this.sysPerms.contains((Object)SecurityPermission.ADMIN_QUERY);
        }
        return ret;
    }

    private void initRules() {
        SecurityPermissionSet permSet = this.subj.permissions();
        this.initRules(permSet.taskPermissions(), this.wildcardTaskPerms, this.strictTaskPerms);
        this.initRules(permSet.cachePermissions(), this.wildcardCachePerms, this.strictCachePerms);
        this.initRules(permSet.servicePermissions(), this.wildcardSrvcPerms, this.strictSrvcPerms);
        this.tracingPerms = permSet.tracingPermissions();
        this.sysPerms = permSet.systemPermissions();
    }

    private void initRules(Map<String, Collection<SecurityPermission>> perms, Map<String, Collection<SecurityPermission>> wildCardPerms, Map<String, Collection<SecurityPermission>> strictPerms) {
        for (Map.Entry<String, Collection<SecurityPermission>> entry : perms.entrySet()) {
            String ptrn = entry.getKey();
            Collection<SecurityPermission> vals = Collections.unmodifiableCollection(entry.getValue());
            if (ptrn != null && ptrn.endsWith("*")) {
                String noWildcard = ptrn.substring(0, ptrn.length() - 1);
                wildCardPerms.put(noWildcard, vals);
                continue;
            }
            strictPerms.put(ptrn, vals);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.subj);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.subj = (SecuritySubject)in.readObject();
        this.initRules();
    }

    public String toString() {
        return S.toString(GridSecurityContext.class, this);
    }
}

