/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.license;

import org.apache.ignite.internal.GridKernalContext;
import org.gridgain.grid.GridProduct;
import org.gridgain.grid.internal.processors.license.LicenseProcessor;
import org.gridgain.grid.product.ProductLicense;
import org.gridgain.grid.product.ProductLicenseException;
import org.jetbrains.annotations.Nullable;

public class GridProductImpl
implements GridProduct {
    private GridKernalContext ctx;
    private LicenseProcessor lic;

    public GridProductImpl(GridKernalContext ctx, LicenseProcessor lic) {
        this.ctx = ctx;
        this.lic = lic;
    }

    @Override
    public long gracePeriodLeft() {
        this.ctx.gateway().readLock();
        try {
            long l = this.lic.gracePeriodLeft();
            return l;
        }
        finally {
            this.ctx.gateway().readUnlock();
        }
    }

    @Override
    @Nullable
    public ProductLicense license() {
        this.ctx.gateway().readLock();
        try {
            ProductLicense productLicense = this.lic.license();
            return productLicense;
        }
        finally {
            this.ctx.gateway().readUnlock();
        }
    }

    @Override
    public void updateLicense(String licTxt) throws ProductLicenseException {
        this.ctx.gateway().readLock();
        try {
            this.lic.updateLicense(licTxt);
        }
        finally {
            this.ctx.gateway().readUnlock();
        }
    }
}

