/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.license;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.license.LicenseField;
import org.gridgain.grid.internal.processors.license.LicenseViolationInfoHolder;

public final class GridLicenseLimitChecker
extends Enum<GridLicenseLimitChecker> {
    public static final /* enum */ GridLicenseLimitChecker MAX_OFFHEAP_SIZE = new GridLicenseLimitChecker("max-offheap-size", (licViolInfoHolder, nodes, limitValue) -> {
        assert (nodes != null);
        double totalOffheap = U.offheapSize(nodes, 6);
        double maxOffheapSize = Double.parseDouble(limitValue);
        if (maxOffheapSize > 0.0 && maxOffheapSize < totalOffheap) {
            licViolInfoHolder.addErrMsg("Maximum cluster off heap size (" + totalOffheap + "/" + maxOffheapSize + ") is exceeded.");
            licViolInfoHolder.addShortMsg("Cluster off heap size is exceeded.");
            licViolInfoHolder.addViolatedField(LicenseField.MAX_OFFHEAP_SIZE);
        }
    });
    public static final /* enum */ GridLicenseLimitChecker MAX_PDS_SIZE = new GridLicenseLimitChecker("max-pds-size", (licViolInfoHolder, nodes, limitValue) -> {
        assert (nodes != null);
        double totalPds = U.allocatedPDSSize(nodes, 6);
        double maxPdsSize = Double.parseDouble(limitValue);
        if (maxPdsSize > 0.0 && maxPdsSize < totalPds) {
            licViolInfoHolder.addErrMsg("Maximum cluster persistence storage (" + totalPds + "/" + maxPdsSize + ") is exceeded.");
            licViolInfoHolder.addShortMsg("Cluster persistence size is exceeded.");
            licViolInfoHolder.addViolatedField(LicenseField.MAX_PDS_SIZE);
        }
    });
    public static final /* enum */ GridLicenseLimitChecker MAX_HEAP_SIZE = new GridLicenseLimitChecker("max-heap-size", (licViolInfoHolder, nodes, limitValue) -> {
        assert (nodes != null);
        double totalHeap = U.heapSize(nodes, 6);
        double maxHeapSize = Double.parseDouble(limitValue);
        if (maxHeapSize > 0.0 && maxHeapSize < totalHeap) {
            licViolInfoHolder.addErrMsg("Maximum cluster heap size (" + totalHeap + "/" + maxHeapSize + ") is exceeded.");
            licViolInfoHolder.addShortMsg("Cluster heap size is exceeded.");
            licViolInfoHolder.addViolatedField(LicenseField.MAX_HEAP_SIZE);
        }
    });
    public static final /* enum */ GridLicenseLimitChecker MAX_RAM_SIZE = new GridLicenseLimitChecker("max-ram-size", (licViolInfoHolder, nodes, limitValue) -> {
        assert (nodes != null);
        double totalRam = U.hostRamSize(nodes, 6);
        double maxRamSize = Double.parseDouble(limitValue);
        if (maxRamSize > 0.0 && maxRamSize < totalRam) {
            licViolInfoHolder.addErrMsg("Maximum cluster RAM size (" + totalRam + "/" + maxRamSize + ") is exceeded.");
            licViolInfoHolder.addShortMsg("Cluster hosts RAM size is exceeded.");
            licViolInfoHolder.addViolatedField(LicenseField.MAX_HOST_RAM_SIZE);
        }
    });
    public static final /* enum */ GridLicenseLimitChecker MAX_SUM_OF_HEAP_AND_OFFHEAP_SIZE = new GridLicenseLimitChecker("max-sum-of-heap-and-offheap-size", (licViolInfoHolder, nodes, limitValue) -> {
        assert (nodes != null);
        double totalSumOfHeapAndOffheap = U.heapSize(nodes, 6) + U.offheapSize(nodes, 6);
        double maxSumOfHeapAndOffheapSize = Double.parseDouble(limitValue);
        if (maxSumOfHeapAndOffheapSize > 0.0 && maxSumOfHeapAndOffheapSize < totalSumOfHeapAndOffheap) {
            licViolInfoHolder.addErrMsg("Maximum cluster sum of heap and offheap size (" + totalSumOfHeapAndOffheap + "/" + maxSumOfHeapAndOffheapSize + ") is exceeded.");
            licViolInfoHolder.addShortMsg("Cluster heap size is exceeded.");
            licViolInfoHolder.addViolatedField(LicenseField.MAX_SUM_OF_HEAP_AND_OFFHEAP_SIZE);
        }
    });
    private String limit;
    private LimitChecker checker;
    private static final /* synthetic */ GridLicenseLimitChecker[] $VALUES;

    public static GridLicenseLimitChecker[] values() {
        return (GridLicenseLimitChecker[])$VALUES.clone();
    }

    public static GridLicenseLimitChecker valueOf(String name) {
        return Enum.valueOf(GridLicenseLimitChecker.class, name);
    }

    private GridLicenseLimitChecker(String limit, LimitChecker checker) {
        this.limit = limit;
        this.checker = checker;
    }

    public String getLimitName() {
        return this.limit;
    }

    public void check(LicenseViolationInfoHolder licViolInfoHldr, Collection<ClusterNode> nodes, String limitValue) {
        this.checker.check(licViolInfoHldr, nodes, limitValue);
    }

    public static Optional<GridLicenseLimitChecker> getChecker(String limit) {
        return Arrays.stream(GridLicenseLimitChecker.values()).filter(proc -> Objects.equals(proc.limit, limit)).findFirst();
    }

    static {
        $VALUES = new GridLicenseLimitChecker[]{MAX_OFFHEAP_SIZE, MAX_PDS_SIZE, MAX_HEAP_SIZE, MAX_RAM_SIZE, MAX_SUM_OF_HEAP_AND_OFFHEAP_SIZE};
    }

    private static interface LimitChecker {
        public void check(LicenseViolationInfoHolder var1, Collection<ClusterNode> var2, String var3);
    }
}

