/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr.maintenance;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.maintenance.MaintenanceAction;
import org.apache.ignite.maintenance.MaintenanceWorkflowCallback;
import org.gridgain.grid.internal.processors.dr.maintenance.CleanupUpdateLogAction;
import org.gridgain.grid.internal.processors.dr.maintenance.RebuildUpdateLogAction;
import org.gridgain.grid.internal.processors.dr.maintenance.RepairUpdateLogTarget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepairUpdateLogWorkflowCallback
implements MaintenanceWorkflowCallback {
    private final List<RepairUpdateLogTarget> partLogsToRebuild;
    private final GridKernalContext ctx;
    private final boolean forceRecovery;

    public RepairUpdateLogWorkflowCallback(List<RepairUpdateLogTarget> partLogsToRebuild, GridKernalContext ctx, boolean forceRecovery) {
        this.partLogsToRebuild = partLogsToRebuild;
        this.ctx = ctx;
        this.forceRecovery = forceRecovery;
    }

    @Override
    public boolean shouldProceedWithMaintenance() {
        return true;
    }

    @Override
    @NotNull
    public List<MaintenanceAction<?>> allActions() {
        return Collections.singletonList(this.createAction());
    }

    @Override
    @Nullable
    public MaintenanceAction<?> automaticAction() {
        return this.createAction();
    }

    private MaintenanceAction<?> createAction() {
        return this.forceRecovery ? new RebuildUpdateLogAction(this.partLogsToRebuild, this.ctx) : new CleanupUpdateLogAction(this.partLogsToRebuild, this.ctx);
    }
}

