/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr.maintenance;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointState;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointManager;
import org.apache.ignite.internal.processors.cache.tree.updatelog.UpdateLog;
import org.apache.ignite.maintenance.MaintenanceAction;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.gridgain.grid.internal.processors.dr.maintenance.RepairUpdateLogTarget;
import org.jetbrains.annotations.Nullable;

public class CleanupUpdateLogAction
implements MaintenanceAction<Boolean> {
    private final List<RepairUpdateLogTarget> targets;
    private final IgniteLogger log;
    private final GridKernalContext kernalContext;

    public CleanupUpdateLogAction(List<RepairUpdateLogTarget> targets, GridKernalContext kernalContext) {
        this.targets = targets;
        this.kernalContext = kernalContext;
        this.log = kernalContext.log(CleanupUpdateLogAction.class);
    }

    @Override
    public String name() {
        return "cleanup";
    }

    @Override
    @Nullable
    public String description() {
        return "Cleaning partition log trees for cache group";
    }

    @Override
    public Boolean execute() {
        if (this.log.isInfoEnabled()) {
            this.log.info("Start cleaning partition log trees.");
        }
        GridCacheProcessor cacheProc = this.kernalContext.cache();
        GridCacheDatabaseSharedManager database = (GridCacheDatabaseSharedManager)cacheProc.context().database();
        CheckpointManager manager = database.getCheckpointManager();
        assert (manager != null);
        try {
            this.prepareForRepair(database);
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to prepare for the cleaning of partition log trees", e);
            return false;
        }
        try {
            for (RepairUpdateLogTarget params : this.targets) {
                CacheGroupContext grpCtx = cacheProc.cacheGroup(params.groupId());
                assert (grpCtx != null);
                this.resetDrState(grpCtx);
                for (GridDhtLocalPartition part : grpCtx.topology().localPartitions()) {
                    this.cleanupPartitionLogTree(grpCtx, part.dataStore());
                }
                manager.forceCheckpoint("afterPartitionLogTreeCleanup", null).futureFor(CheckpointState.FINISHED).get();
            }
        }
        catch (Exception e) {
            this.log.error("Failed to clean partition log tree.", e);
            return false;
        }
        this.unregisterMaintenanceTask(this.kernalContext);
        if (this.log.isInfoEnabled()) {
            this.log.info("Cleaning partition log trees done.");
        }
        return true;
    }

    private void resetDrState(CacheGroupContext grpCtx) {
        List<Integer> cachesToProcess = this.cachesInGroup(grpCtx);
        cachesToProcess.forEach(c -> this.resetDrState(grpCtx.shared().cacheContext((int)c)));
    }

    private void resetDrState(GridCacheContext cctx) {
        try {
            DrUtils.resetDrState(cctx.shared().database(), DrUtils.drStateMetastorageKey(cctx.name()));
        }
        catch (IgniteCheckedException e) {
            this.log.warning("Failed to clear DR state for cache=" + cctx.name(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupPartitionLogTree(CacheGroupContext grpCtx, IgniteCacheOffheapManager.CacheDataStore dataStore) throws IgniteCheckedException {
        IgniteCacheDatabaseSharedManager database = grpCtx.shared().database();
        if (!dataStore.logTree().hasTree()) {
            this.log.info("Log tree was not found for partition: cacheGroup=" + grpCtx.cacheOrGroupName() + ", part=" + dataStore.partId());
            return;
        }
        database.checkpointReadLock();
        try {
            ((GridCacheOffheapManager.GridCacheDataStore)dataStore).dropPartitionLogTree();
        }
        finally {
            database.checkpointReadUnlock();
        }
        UpdateLog updateLog = dataStore.logTree();
        if (!updateLog.hasTree()) {
            this.log.info("Log tree has been dropped for partition: cacheGroup=" + grpCtx.cacheOrGroupName() + ", part=" + dataStore.partId());
            return;
        }
        assert (updateLog.tree().size() == 0L) : updateLog.tree().name();
        this.log.info("Log tree has been re-created for partition: cacheGroup=" + grpCtx.cacheOrGroupName() + ", part=" + dataStore.partId());
    }

    private List<Integer> cachesInGroup(CacheGroupContext grpCtx) {
        if (!grpCtx.hasCaches()) {
            return Collections.emptyList();
        }
        return grpCtx.caches().stream().map(GridCacheContext::cacheId).sorted(Integer::compareTo).collect(Collectors.toList());
    }

    private void prepareForRepair(GridCacheDatabaseSharedManager database) throws IgniteCheckedException {
        database.resumeWalLogging();
        database.onStateRestored(null);
    }

    private void unregisterMaintenanceTask(GridKernalContext kernalContext) {
        kernalContext.maintenanceRegistry().unregisterMaintenanceTask("PartitionLogTreeCleanupMaintenanceTask");
    }
}

