/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr.fst;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorkerListener;
import org.gridgain.grid.internal.processors.dr.fst.Batch;
import org.gridgain.grid.internal.processors.dr.fst.DrAffinityAwareWorker;
import org.gridgain.grid.internal.processors.dr.fst.StateTransferJob;
import org.gridgain.grid.internal.processors.dr.fst.StateTransferTask;
import org.jetbrains.annotations.Nullable;

class StateTransferWorker
extends DrAffinityAwareWorker {
    private final BlockingQueue<StateTransferTask<Batch>> taskQ;

    StateTransferWorker(GridKernalContext ctx, CountDownLatch started, BlockingQueue<StateTransferTask<Batch>> taskQ, @Nullable GridWorkerListener lsnr) {
        super(ctx, "dr-state-transfer-pool-worker", ctx.log(StateTransferWorker.class), started, lsnr);
        this.taskQ = taskQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void body0() {
        block20: {
            try {
                StateTransferTask<Batch> curTask = null;
                Batch batch = null;
                while (!this.isCancelled()) {
                    StateTransferJob<Batch> job;
                    StateTransferTask<Batch> prevTask = curTask;
                    this.blockingSectionBegin();
                    try {
                        if (batch == null) {
                            curTask = this.taskQ.take();
                        } else {
                            curTask = this.taskQ.poll(1L, TimeUnit.SECONDS);
                            if (curTask == null || prevTask != curTask || curTask.isCancelled()) {
                                batch.flush();
                                batch = null;
                            }
                        }
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                    if (curTask == null) {
                        this.onIdle();
                    }
                    if (curTask == null || curTask.isCancelled() || (job = curTask.nextJob()) == null) continue;
                    this.taskQ.offer(curTask);
                    if (batch == null) {
                        batch = curTask.createBatch();
                    }
                    this.blockingSectionBegin();
                    try {
                        job.runWithBatch(batch);
                    }
                    catch (Throwable e) {
                        if (!this.isCancelled()) {
                            U.error(this.log, "An exception occurred during DR task processing.", e);
                        } else if (this.log.isDebugEnabled()) {
                            this.log.debug("An exception occurred during DR task processing: " + e);
                        }
                        if (!(e instanceof Error)) continue;
                        throw (Error)e;
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                }
            }
            catch (Exception e) {
                if (this.isCancelled() && !this.log.isDebugEnabled()) break block20;
                this.log.error("DR task worker failed.", e);
            }
        }
    }
}

