/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.dr.DrSenderInMetrics;
import org.jetbrains.annotations.Nullable;

class DrSenderInMetricsAggregate
implements DrSenderInMetrics {
    private long batchesReceived;
    private long entriesReceived;
    private long bytesReceived;
    private long batchesRejected;

    public DrSenderInMetricsAggregate() {
    }

    public DrSenderInMetricsAggregate(@Nullable DrSenderInMetrics m4) {
        if (m4 != null) {
            this.batchesReceived = m4.batchesReceived();
            this.entriesReceived = m4.entriesReceived();
            this.bytesReceived = m4.bytesReceived();
            this.batchesRejected = m4.batchesRejected();
        }
    }

    @Override
    public int batchesReceived() {
        return (int)this.batchesReceived;
    }

    @Override
    public long entriesReceived() {
        return this.entriesReceived;
    }

    @Override
    public long bytesReceived() {
        return this.bytesReceived;
    }

    @Override
    public int batchesRejected() {
        return (int)this.batchesRejected;
    }

    void aggregate(DrSenderInMetrics m4) {
        if (m4 != null) {
            this.batchesReceived += (long)m4.batchesReceived();
            this.entriesReceived += m4.entriesReceived();
            this.bytesReceived += m4.bytesReceived();
            this.batchesRejected += (long)m4.batchesRejected();
        }
    }

    public String toString() {
        return S.toString(DrSenderInMetricsAggregate.class, this);
    }
}

