/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.internal.processors.dr.DrSenderRemoteAttributes;
import org.jetbrains.annotations.Nullable;

public class DrSenderAttributes
implements Externalizable {
    private static final long serialVersionUID = -1160292180312857122L;
    @Deprecated
    private Collection<String> cacheNames;
    private String storeClsName;
    private Collection<DrSenderRemoteAttributes> rmtAttrs;
    private Set<Byte> dataCenterIds;
    private Collection<Byte> ignoreList;
    private Map<Byte, Collection<Byte>> replicasIgnore;

    public DrSenderAttributes() {
    }

    public DrSenderAttributes(DrSenderConfiguration sndHubCfg) {
        assert (!F.isEmpty(sndHubCfg.getConnectionConfiguration()));
        this.cacheNames = F.isEmpty(sndHubCfg.getCacheNames()) ? Collections.emptyList() : Arrays.asList(sndHubCfg.getCacheNames());
        this.rmtAttrs = new ArrayList<DrSenderRemoteAttributes>();
        for (DrSenderConnectionConfiguration replicaCfg : sndHubCfg.getConnectionConfiguration()) {
            this.rmtAttrs.add(new DrSenderRemoteAttributes(replicaCfg));
        }
        this.parseRemoteAttributes(this.rmtAttrs);
        if (sndHubCfg.getStore() != null) {
            this.storeClsName = sndHubCfg.getStore().getClass().getName();
        }
    }

    public Collection<String> getCacheNames() {
        return this.cacheNames;
    }

    @Nullable
    public String getStoreClassName() {
        return this.storeClsName;
    }

    public Collection<DrSenderRemoteAttributes> getRmtAttrs() {
        return this.rmtAttrs;
    }

    public Set<Byte> getDataCenterIds() {
        return this.dataCenterIds;
    }

    public Collection<Byte> getIgnoreList() {
        return this.ignoreList;
    }

    public Map<Byte, Collection<Byte>> getReplicasIgnore() {
        return this.replicasIgnore;
    }

    private void parseRemoteAttributes(Iterable<DrSenderRemoteAttributes> rmtAttrs) {
        this.replicasIgnore = new HashMap<Byte, Collection<Byte>>();
        this.dataCenterIds = new HashSet<Byte>();
        HashSet ignoreList0 = null;
        for (DrSenderRemoteAttributes rmtAttr : rmtAttrs) {
            this.dataCenterIds.add(rmtAttr.getDataCenterId());
            if (rmtAttr.getReplicasIgnore() == null) continue;
            ArrayList<Byte> ignored = new ArrayList<Byte>();
            for (byte replica : rmtAttr.getReplicasIgnore()) {
                ignored.add(replica);
            }
            this.replicasIgnore.put(rmtAttr.getDataCenterId(), ignored);
            if (ignoreList0 == null) {
                ignoreList0 = new HashSet(ignored);
                continue;
            }
            ignoreList0.retainAll(ignored);
        }
        this.ignoreList = F.isEmpty(ignoreList0) ? Collections.emptyList() : new ArrayList(ignoreList0);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeCollection(out, this.cacheNames);
        U.writeString(out, this.storeClsName);
        U.writeCollection(out, this.rmtAttrs);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cacheNames = U.readCollection(in);
        this.storeClsName = U.readString(in);
        this.rmtAttrs = U.readCollection(in);
        this.parseRemoteAttributes(this.rmtAttrs);
    }

    public String toString() {
        return S.toString(DrSenderAttributes.class, this, super.toString());
    }
}

