/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.cache.dr.CacheDrReceiverMetrics;
import org.gridgain.grid.cache.dr.CacheDrSenderMetrics;
import org.gridgain.grid.cache.dr.CacheDrStateTransfer;
import org.gridgain.grid.cache.dr.CacheDrStatus;
import org.gridgain.grid.dr.DrReceiverInMetrics;
import org.gridgain.grid.dr.DrReceiverOutMetrics;
import org.gridgain.grid.dr.DrSender;
import org.gridgain.grid.dr.DrSenderInMetrics;
import org.gridgain.grid.dr.DrSenderOutMetrics;
import org.gridgain.grid.internal.processors.cache.dr.CacheDrManager;
import org.gridgain.grid.internal.processors.dr.DrMetricsManager;
import org.gridgain.grid.internal.processors.dr.DrProcessor;
import org.gridgain.grid.internal.processors.dr.DrReceiverInMetricsHolder;
import org.gridgain.grid.internal.processors.dr.DrSenderOutMetricsHolder;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.jetbrains.annotations.Nullable;

public class DrImpl
implements GridDr,
Externalizable {
    private static final long serialVersionUID = 0L;
    private DrProcessor drProc;
    private GridCacheProcessor cacheProc;
    private Collection<Byte> allDcIds;
    private GridKernalContext ctx;

    public DrImpl() {
    }

    DrImpl(DrProcessor drProc, GridKernalContext ctx) {
        assert (drProc != null);
        assert (ctx.cache() != null);
        this.drProc = drProc;
        this.ctx = ctx;
        this.cacheProc = ctx.cache();
        ArrayList<Byte> allDcIds0 = new ArrayList<Byte>(31);
        for (int i = 1; i < 32; ++i) {
            byte dc = (byte)i;
            if (F.eq(drProc.ggConfig().getDataCenterId(), dc)) continue;
            allDcIds0.add((byte)i);
        }
        this.allDcIds = allDcIds0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<?> stateTransfer(String cacheName, boolean sync, byte ... dataCenterIds) {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            Collection<Byte> dcIds;
            if (F.isEmpty(dataCenterIds)) {
                dcIds = this.allDcIds;
            } else {
                dcIds = new ArrayList<Byte>(dataCenterIds.length);
                for (byte id : dataCenterIds) {
                    dcIds.add(id);
                }
            }
            IgniteFutureImpl igniteFutureImpl = new IgniteFutureImpl(this.dr(cacheName).startStateTransfer(dcIds, sync));
            this.ctx.gateway().readUnlock();
            return igniteFutureImpl;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    @Override
    public IgniteFuture<?> stateTransfer(String cacheName, byte ... dataCenterIds) {
        return this.stateTransfer(cacheName, false, dataCenterIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<?> incrementalStateTransfer(String cacheName, long snapshotId, byte dataCenterId) {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            IgniteFutureImpl igniteFutureImpl = new IgniteFutureImpl(this.dr(cacheName).incrementalStateTransfer(snapshotId, dataCenterId));
            this.ctx.gateway().readUnlock();
            return igniteFutureImpl;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    @Override
    public IgniteFuture<?> cancelStateTransfer(IgniteUuid uid) {
        Objects.requireNonNull(uid);
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            IgniteFutureImpl igniteFutureImpl = new IgniteFutureImpl(this.drProc.cancelStateTransfer(uid));
            this.ctx.gateway().readUnlock();
            return igniteFutureImpl;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    @Override
    public Collection<CacheDrStateTransfer> listStateTransfers(String cacheName) {
        Objects.requireNonNull(cacheName);
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            Collection<CacheDrStateTransfer> collection = this.dr(cacheName).activeStateTransferTasks();
            this.ctx.gateway().readUnlock();
            return collection;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    @Override
    public Collection<CacheDrStateTransfer> listStateTransfers() {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            Collection<CacheDrStateTransfer> collection = this.drProc.listStateTransfers();
            this.ctx.gateway().readUnlock();
            return collection;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    @Override
    @Deprecated
    public void pause(String cacheName) {
        this.stopReplication(cacheName);
    }

    @Override
    @Deprecated
    public void resume(String cacheName) {
        this.startReplication(cacheName);
    }

    @Override
    public void stopReplication(String cacheName) {
        try {
            this.ctx.cache().awaitStarted();
            this.ctx.gateway().readLock();
            try {
                this.dr(cacheName).stopReplication();
            }
            finally {
                this.ctx.gateway().readUnlock();
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public void startReplication(String cacheName) {
        try {
            this.ctx.cache().awaitStarted();
            this.ctx.gateway().readLock();
            try {
                this.dr(cacheName).startReplication();
            }
            finally {
                this.ctx.gateway().readUnlock();
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    @Nullable
    public CacheDrStatus senderCacheStatus(String cacheName) {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            CacheDrStatus cacheDrStatus = this.dr(cacheName).drStatus();
            this.ctx.gateway().readUnlock();
            return cacheDrStatus;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    @Override
    public CacheDrSenderMetrics senderCacheMetrics(String cacheName) {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            CacheDrSenderMetrics cacheDrSenderMetrics = this.dr(cacheName).metrics().drSendMetrics();
            this.ctx.gateway().readUnlock();
            return cacheDrSenderMetrics;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    @Override
    public CacheDrReceiverMetrics receiverCacheMetrics(String cacheName) {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            CacheDrReceiverMetrics cacheDrReceiverMetrics = this.dr(cacheName).metrics().drReceiveMetrics();
            this.ctx.gateway().readUnlock();
            return cacheDrReceiverMetrics;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrSenderInMetrics senderInMetrics(String cacheName) {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not sender hub.");
            }
            DrSenderInMetrics drSenderInMetrics = metrics.senderHubInMetrics(cacheName);
            this.ctx.gateway().readUnlock();
            return drSenderInMetrics;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    @Override
    public DrSenderInMetrics senderAggregatedInMetrics() {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not sender hub.");
            }
            DrSenderInMetrics drSenderInMetrics = metrics.senderHubInMetrics();
            this.ctx.gateway().readUnlock();
            return drSenderInMetrics;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrSenderOutMetrics senderOutMetrics(byte destDataCenterId, @Nullable String cacheName) {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not sender hub.");
            }
            DrSenderOutMetrics drSenderOutMetrics = metrics.senderHubOutMetrics(destDataCenterId, cacheName);
            this.ctx.gateway().readUnlock();
            return drSenderOutMetrics;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrSenderOutMetrics senderAggregatedOutMetrics(byte destDataCenterId) {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not sender hub.");
            }
            DrSenderOutMetricsHolder drSenderOutMetricsHolder = metrics.senderHubOutMetrics(destDataCenterId);
            this.ctx.gateway().readUnlock();
            return drSenderOutMetricsHolder;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrSenderOutMetrics senderAggregatedOutMetrics(@Nullable String cacheName) {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not sender hub.");
            }
            DrSenderOutMetricsHolder drSenderOutMetricsHolder = metrics.senderHubOutMetrics(cacheName);
            this.ctx.gateway().readUnlock();
            return drSenderOutMetricsHolder;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    @Override
    public DrSenderOutMetrics senderAggregatedOutMetrics() {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not sender hub.");
            }
            DrSenderOutMetricsHolder drSenderOutMetricsHolder = metrics.senderHubOutMetrics();
            this.ctx.gateway().readUnlock();
            return drSenderOutMetricsHolder;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrReceiverInMetrics receiverInMetrics(byte srcDataCenterId, @Nullable String cacheName) {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not receiver hub.");
            }
            DrReceiverInMetricsHolder drReceiverInMetricsHolder = metrics.receiverHubInMetrics(srcDataCenterId, cacheName);
            this.ctx.gateway().readUnlock();
            return drReceiverInMetricsHolder;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrReceiverInMetrics receiverAggregatedInMetrics(byte srcDataCenterId) {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not receiver hub.");
            }
            DrReceiverInMetricsHolder drReceiverInMetricsHolder = metrics.receiverHubInMetrics(srcDataCenterId);
            this.ctx.gateway().readUnlock();
            return drReceiverInMetricsHolder;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrReceiverInMetrics receiverAggregatedInMetrics(@Nullable String cacheName) {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not receiver hub.");
            }
            DrReceiverInMetricsHolder drReceiverInMetricsHolder = metrics.receiverHubInMetrics(cacheName);
            this.ctx.gateway().readUnlock();
            return drReceiverInMetricsHolder;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    @Override
    public DrReceiverInMetrics receiverAggregatedInMetrics() {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not receiver hub.");
            }
            DrReceiverInMetricsHolder drReceiverInMetricsHolder = metrics.receiverHubInMetrics();
            this.ctx.gateway().readUnlock();
            return drReceiverInMetricsHolder;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrReceiverOutMetrics receiverOutMetrics(@Nullable String cacheName) {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not receiver hub.");
            }
            DrReceiverOutMetrics drReceiverOutMetrics = metrics.receiverHubOutMetrics(cacheName);
            this.ctx.gateway().readUnlock();
            return drReceiverOutMetrics;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrReceiverOutMetrics receiverOutMetrics(byte srcDataCenterId, @Nullable String cacheName) {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not receiver hub.");
            }
            DrReceiverOutMetrics drReceiverOutMetrics = metrics.receiverHubOutMetrics(srcDataCenterId, cacheName);
            this.ctx.gateway().readUnlock();
            return drReceiverOutMetrics;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    @Override
    public DrReceiverOutMetrics receiverAggregatedOutMetrics() {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            DrMetricsManager metrics = this.drProc.metrics();
            if (metrics == null) {
                throw new IllegalStateException("Node is not receiver hub.");
            }
            DrReceiverOutMetrics drReceiverOutMetrics = metrics.receiverHubOutMetrics();
            this.ctx.gateway().readUnlock();
            return drReceiverOutMetrics;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    private CacheDrManager dr(String cacheName) throws IgniteCheckedException {
        return DrUtils.dr(this.ctx, this.cacheProc, cacheName);
    }

    @Override
    public void resetMetrics() {
        this.drProc.resetMetrics();
    }

    @Override
    public boolean isLocalSender() {
        return this.drProc.senderHub() != null;
    }

    @Override
    public DrSender localSender() {
        if (!this.isLocalSender()) {
            throw new IllegalStateException("Data center replication sender is not configured for current node.");
        }
        return this.drProc.senderHub();
    }

    @Override
    public IgniteFuture<?> flush(String cacheName) {
        this.ctx.cache().awaitStarted();
        this.ctx.gateway().readLock();
        try {
            IgniteFutureImpl igniteFutureImpl = new IgniteFutureImpl(this.dr(cacheName).flush());
            this.ctx.gateway().readUnlock();
            return igniteFutureImpl;
        }
        catch (Throwable throwable) {
            try {
                this.ctx.gateway().readUnlock();
                throw throwable;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ctx);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ctx = (GridKernalContext)in.readObject();
    }

    protected Object readResolve() throws ObjectStreamException {
        GridGain plugin = (GridGain)this.ctx.grid().plugin("GridGain");
        return plugin.dr();
    }
}

