/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr.ist;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.ignite.IgniteException;

public class Watermark {
    private static final int MAX_MISSED_UPDATES = 10000;
    private final NavigableMap<Long, Item> queue = new TreeMap<Long, Item>();
    private volatile long val;

    public Watermark(long val) {
        this.val = val;
    }

    public long get() {
        return this.val;
    }

    public synchronized boolean update(long from, long to) {
        Item item;
        if (to == from || to <= this.val) {
            return false;
        }
        assert (from < to);
        long cur = this.val;
        if (cur < from) {
            Map.Entry<Long, Item> prev;
            long next = to;
            Item nextItem = (Item)this.queue.remove(next);
            if (nextItem != null) {
                to = nextItem.end();
            }
            if ((prev = this.queue.lowerEntry(from)) != null) {
                Item prevItem = prev.getValue();
                if (prevItem.end() == from) {
                    prevItem.end(to);
                    return false;
                }
                if (prevItem.end() >= next) {
                    return false;
                }
            }
            if (this.queue.size() >= 10000) {
                throw new IgniteException("Too many gaps [cntr=" + this + ']');
            }
            this.queue.putIfAbsent(from, new Item(from, to));
            return false;
        }
        assert (to > cur);
        while (!this.queue.isEmpty() && (item = this.queue.firstEntry().getValue()).start() <= to) {
            this.queue.pollFirstEntry();
            if (item.end() <= to) continue;
            to = item.end();
        }
        this.val = to;
        return true;
    }

    public String toString() {
        return "Watermark[val=" + this.val + ", qeued=" + this.queue.size() + ']';
    }

    private static class Item {
        private final long start;
        private long end;

        private Item(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "Item [start=" + this.start + ", target=" + this.end + ']';
        }

        public long start() {
            return this.start;
        }

        public long end() {
            return this.end;
        }

        public void end(long end) {
            this.end = end;
        }

        public int hashCode() {
            return Long.hashCode(this.start);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            return this.start == item.start && this.end == item.end;
        }
    }
}

