/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr.ist;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.internal.processors.cache.dr.CacheDrStateTransferKey;
import org.jetbrains.annotations.Nullable;

public class StateTransferInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 0L;
    private final CacheDrStateTransferKey fstKey;
    private final int cacheId;
    private final BitSet pendingParts;
    private long startTime;
    private Long snapshotId;

    public StateTransferInfo(CacheDrStateTransferKey fstKey, int cacheId, int parts, long startTime, @Nullable Long snapshotId) {
        this.fstKey = fstKey;
        this.cacheId = cacheId;
        this.pendingParts = new BitSet(parts);
        this.startTime = startTime;
        this.snapshotId = snapshotId;
    }

    public StateTransferInfo(StateTransferInfo info) {
        this.fstKey = info.fstKey;
        this.cacheId = info.cacheId;
        this.pendingParts = (BitSet)info.pendingParts.clone();
    }

    public CacheDrStateTransferKey fstKey() {
        return this.fstKey;
    }

    public IgniteUuid fstId() {
        return this.fstKey.id();
    }

    public Collection<Byte> targetDCs() {
        return this.fstKey.dataCenterIds();
    }

    public Long snapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(Long snapshotId) {
        this.snapshotId = snapshotId;
    }

    public UUID nodeInitiator() {
        return this.fstKey.id().globalId();
    }

    public int cacheId() {
        return this.cacheId;
    }

    public int partsToTransfer() {
        return this.pendingParts.cardinality();
    }

    public long startTime() {
        return this.startTime;
    }

    public BitSet pendingParts() {
        return this.pendingParts;
    }

    public void markDelivered(int part) {
        this.pendingParts.clear(part);
    }

    public boolean needToSend(int part) {
        return this.pendingParts.get(part);
    }

    public boolean isFinished() {
        return this.pendingParts.cardinality() == 0;
    }

    public byte[] targetDcBits() {
        BitSet targetDCs = new BitSet(32);
        for (Byte dc : this.fstKey.dataCenterIds()) {
            targetDCs.set(dc.byteValue());
        }
        return targetDCs.toByteArray();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateTransferInfo info = (StateTransferInfo)o;
        return this.cacheId == info.cacheId && Objects.equals(this.fstKey.id(), info.fstKey.id()) && Objects.equals(this.pendingParts, info.pendingParts);
    }

    public int hashCode() {
        return Objects.hash(this.fstKey.id());
    }

    public String toString() {
        return "StateTransferInfo[fstId=" + this.fstKey.id() + ", cacheId=" + this.cacheId + ", initiator=" + this.fstKey.id().globalId() + ", targetDCs=" + this.fstKey.dataCenterIds() + ']';
    }
}

