/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr.ist;

import org.gridgain.grid.internal.processors.cache.dr.ist.Watermark;

public class PartitionDrState {
    public static final long FST_WM_MIN_VALUE = Long.MIN_VALUE;
    public static final long LWM_MIN_VALUE = 0L;
    private final int part;
    private final Watermark lastUpdateCntr;
    private final Watermark lwm;
    private volatile long cwm;
    private volatile Watermark fstWM;

    PartitionDrState(int part, long lwm) {
        this.part = part;
        this.lwm = new Watermark(lwm);
        this.lastUpdateCntr = new Watermark(lwm);
        this.fstWM = new Watermark(Long.MIN_VALUE);
    }

    public long lwm() {
        return this.lwm.get();
    }

    boolean lwm(long from, long to) {
        return this.lwm.update(from, to);
    }

    public long lastUpdCntr() {
        return this.lastUpdateCntr.get();
    }

    boolean lastUpdCntr(long from, long to) {
        return this.lastUpdateCntr.update(from, to);
    }

    public long cwm() {
        return this.cwm;
    }

    synchronized void cwm(long updCntr) {
        if (this.cwm < updCntr) {
            this.cwm = updCntr;
        }
    }

    public long fstWM() {
        return this.fstWM.get();
    }

    public void fstWM(long from, long to) {
        if (from == to) {
            return;
        }
        if (from != Long.MIN_VALUE) {
            from &= 0xFFFFFFFF00000000L;
        }
        if (to != Long.MAX_VALUE) {
            to &= 0xFFFFFFFF00000000L;
        }
        this.fstWM.update(from, to);
    }

    public void resetFstWM() {
        this.fstWM = new Watermark(Long.MIN_VALUE);
    }

    public String toString() {
        return "[part=" + this.part + ", lastUpdateCntr=" + this.lastUpdateCntr + ", lwm=" + this.lwm + ", cwm=" + this.cwm + ", fstwm=" + this.fstWM + ']';
    }
}

