/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr.ist;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrSenderNode;

interface LoadBalancer<T> {
    public T apply(List<T> var1);

    public static class RandomBalancer
    implements LoadBalancer<DrSenderNode> {
        @Override
        public DrSenderNode apply(List<DrSenderNode> nodes) {
            return nodes.get(ThreadLocalRandom.current().nextInt(nodes.size()));
        }
    }

    public static class RoundRobinBalancer
    implements LoadBalancer<DrSenderNode> {
        private static final AtomicIntegerFieldUpdater<RoundRobinBalancer> LAST_IDX_UPD = AtomicIntegerFieldUpdater.newUpdater(RoundRobinBalancer.class, "lastIdx");
        private volatile int lastIdx;

        @Override
        public DrSenderNode apply(List<DrSenderNode> nodes) {
            int idx;
            int idx0;
            do {
                if ((idx = (idx0 = LAST_IDX_UPD.get(this)) + 1) < nodes.size()) continue;
                idx = 0;
            } while (!LAST_IDX_UPD.compareAndSet(this, idx0, idx));
            return nodes.get(idx);
        }
    }
}

