/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr.ist;

import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.gridgain.grid.cache.dr.CacheDrPauseReason;
import org.gridgain.grid.cache.dr.CacheDrStatus;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrStateAware;
import org.gridgain.grid.internal.processors.cache.dr.ist.distributed.DistributedDrStateManager;

public class DrStateHolder {
    private static final CacheDrStatus STATUS_ACTIVE = new CacheDrStatus(null, null);
    public static final CacheDrStatus STATUS_NO_SND_HUBS = new CacheDrStatus(CacheDrPauseReason.NO_SND_HUBS, "No sender hubs.");
    public static final CacheDrStatus STATUS_FAILED = new CacheDrStatus(CacheDrPauseReason.BATCH_FAILED, "Batch failed.");
    public static final CacheDrStatus STATUS_USER_REQUEST = new CacheDrStatus(CacheDrPauseReason.USER_REQUEST, null);
    private volatile CacheDrPauseReason globalState;
    private volatile boolean noSndHub = true;
    private final DistributedDrStateManager distrStateMgr;
    private DrStateAware[] stateAwareHandlers = new DrStateAware[0];

    public DrStateHolder(DistributedDrStateManager distrStateMgr) {
        this.distrStateMgr = distrStateMgr;
        this.distrStateMgr.listen(this::onGlobalDrStatusChanged);
    }

    public void subscribe(DrStateAware ... lsnrs) {
        Objects.requireNonNull(lsnrs);
        this.stateAwareHandlers = lsnrs;
    }

    public boolean isActive() {
        return this.globalState == null && !this.noSndHub;
    }

    public CacheDrStatus drStatus() {
        CacheDrPauseReason state = this.globalState;
        if (state != null) {
            switch (state) {
                case BATCH_FAILED: {
                    return STATUS_FAILED;
                }
                case USER_REQUEST: {
                    return STATUS_USER_REQUEST;
                }
                case NO_SND_HUBS: {
                    return this.noSndHub ? STATUS_NO_SND_HUBS : STATUS_ACTIVE;
                }
            }
        }
        return this.noSndHub ? STATUS_NO_SND_HUBS : STATUS_ACTIVE;
    }

    public IgniteInternalFuture<?> fail() {
        return this.distrStateMgr.changeState(CacheDrPauseReason.BATCH_FAILED);
    }

    public IgniteInternalFuture<?> stopReplication() {
        return this.distrStateMgr.changeState(CacheDrPauseReason.USER_REQUEST);
    }

    public IgniteInternalFuture<?> startReplication() {
        return this.distrStateMgr.changeState(null);
    }

    void onSenderHubJoin() {
        if (this.noSndHub) {
            this.noSndHub = false;
            if (this.globalState == null) {
                Arrays.stream(this.stateAwareHandlers).forEach(s2 -> s2.onResume());
            }
        }
    }

    void onNoSenderHubs() {
        if (!this.noSndHub) {
            this.noSndHub = true;
            if (this.globalState == null) {
                Arrays.stream(this.stateAwareHandlers).forEach(s2 -> s2.onPause());
            }
        }
    }

    private void onGlobalDrStatusChanged(CacheDrPauseReason newState) {
        CacheDrPauseReason oldState = this.globalState;
        if (oldState == newState) {
            return;
        }
        this.globalState = newState;
        if (this.noSndHub) {
            return;
        }
        if (newState == null) {
            Arrays.stream(this.stateAwareHandlers).forEach(s2 -> s2.onResume());
        } else if (oldState == null) {
            Arrays.stream(this.stateAwareHandlers).forEach(s2 -> s2.onPause());
        }
    }
}

