/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr.ist;

import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.gridgain.grid.internal.processors.dr.messages.DrInternalRequest;
import org.gridgain.grid.internal.processors.dr.messages.DrInternalResponse;

public class DrSenderNode {
    private static final int INITIAL_DELAY = 100;
    private static final int MAX_DELAY = 10000;
    private final GridIoManager ioMgr;
    private final GridTimeoutProcessor scheduler;
    private final UUID nodeId;
    private final AtomicInteger retries = new AtomicInteger();
    private volatile GridTimeoutProcessor.CancelableTask activateTask;
    private final Set<Long> unprocessedReqs = ConcurrentHashMap.newKeySet();

    public DrSenderNode(GridIoManager ioMgr, GridTimeoutProcessor scheduler, UUID nodeId) {
        this.ioMgr = ioMgr;
        this.scheduler = scheduler;
        this.nodeId = nodeId;
    }

    public boolean active() {
        return this.activateTask == null;
    }

    public UUID id() {
        return this.nodeId;
    }

    public synchronized void temporarilySwitchOff() {
        if (this.activateTask != null) {
            return;
        }
        long delay = Math.min(10000L, (long)(Math.pow(1.5, this.retries.incrementAndGet()) * 100.0));
        this.activateTask = this.scheduler.schedule(this::switchOn, delay, -1L);
    }

    public synchronized void switchOn() {
        if (this.activateTask == null) {
            return;
        }
        this.activateTask = null;
    }

    private synchronized void reset() {
        this.switchOn();
        this.retries.set(0);
    }

    public void onResponse(DrInternalResponse resp) {
        byte code = resp.code();
        if (code != 1 && resp.error() == null) {
            this.reset();
        }
        if (code == 1) {
            this.temporarilySwitchOff();
        } else {
            if (code == 2) {
                return;
            }
            this.unprocessedReqs.remove(resp.id());
        }
    }

    public Set<Long> unprocessedRequests() {
        return Collections.unmodifiableSet(this.unprocessedReqs);
    }

    public void clearUnprocessedRequests() {
        this.unprocessedReqs.clear();
    }

    public void send(DrInternalRequest req) throws IgniteCheckedException {
        this.unprocessedReqs.add(req.id());
        this.ioMgr.sendToCustomTopic(this.nodeId, (Object)CU.replicationTopicSend(), (Message)req, (byte)33);
    }
}

