/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.internal.processors.cache.GridCacheInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.internal.processors.cache.dr.CacheDrStateTransferKey;

public class CacheDrStateTransferResultKey
implements Externalizable,
GridCacheInternal {
    private static final long serialVersionUID = 0L;
    private String cacheName;
    private IgniteUuid id;
    private Collection<Byte> dataCenterIds;

    public static CacheDrStateTransferResultKey fromStateTransferKey(CacheDrStateTransferKey key) {
        return new CacheDrStateTransferResultKey(key.cacheName(), key.id(), new ArrayList<Byte>(key.dataCenterIds()));
    }

    public CacheDrStateTransferResultKey() {
    }

    public CacheDrStateTransferResultKey(String cacheName, IgniteUuid id, Collection<Byte> dataCenterIds) {
        this.cacheName = cacheName;
        this.id = id;
        this.dataCenterIds = dataCenterIds;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public IgniteUuid id() {
        return this.id;
    }

    public Collection<Byte> dataCenterIds() {
        return this.dataCenterIds;
    }

    public boolean equals(Object obj) {
        return obj instanceof CacheDrStateTransferResultKey && F.eq(this.id, ((CacheDrStateTransferResultKey)obj).id());
    }

    public int hashCode() {
        int res = this.id.hashCode();
        res = 31 * res + (this.cacheName == null ? 0 : this.cacheName.hashCode());
        return res;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.cacheName);
        U.writeGridUuid(out, this.id);
        U.writeByteCollection(out, this.dataCenterIds);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cacheName = U.readString(in);
        this.id = U.readGridUuid(in);
        try {
            this.dataCenterIds = U.readByteList(in);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public String toString() {
        return S.toString(CacheDrStateTransferResultKey.class, this);
    }
}

