/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.cache.dr.CacheDrSenderConfiguration;
import org.gridgain.grid.dr.DrSenderLoadBalancingMode;
import org.jetbrains.annotations.Nullable;

public class CacheDrSenderAttributes
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private DrSenderLoadBalancingMode sndHubLoadBalancingPlc;
    private String entryFilterClsName;

    public CacheDrSenderAttributes() {
    }

    public CacheDrSenderAttributes(CacheDrSenderConfiguration cfg) {
        assert (cfg != null);
        this.entryFilterClsName = CacheDrSenderAttributes.className(cfg.getEntryFilter());
        this.sndHubLoadBalancingPlc = cfg.getLoadBalancingMode();
    }

    public DrSenderLoadBalancingMode senderHubLoadBalancingPolicy() {
        return this.sndHubLoadBalancingPlc;
    }

    public String entryFilterClassName() {
        return this.entryFilterClsName;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeEnum(out, this.sndHubLoadBalancingPlc);
        U.writeString(out, this.entryFilterClsName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sndHubLoadBalancingPlc = DrSenderLoadBalancingMode.fromOrdinal(in.readByte());
        this.entryFilterClsName = U.readString(in);
    }

    @Nullable
    private static String className(@Nullable Object obj) {
        return obj != null ? obj.getClass().getName() : null;
    }
}

