/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr;

import java.util.Collections;
import org.gridgain.grid.cache.dr.CacheDrMBean;
import org.gridgain.grid.cache.dr.CacheDrStatus;
import org.gridgain.grid.internal.processors.cache.dr.GridGainCacheDrManager;

public class CacheDrMBeanAdapter
implements CacheDrMBean {
    private final GridGainCacheDrManager dr;

    CacheDrMBeanAdapter(GridGainCacheDrManager dr) {
        this.dr = dr;
    }

    @Override
    public int getDrQueuedKeysCount() {
        return this.dr.queuedKeysCount();
    }

    @Override
    public int getDrBackupQueueSize() {
        return this.dr.queuedKeysCount();
    }

    @Override
    public int getDrBatchWaitingSendCount() {
        return this.dr.batchWaitingSendCount();
    }

    @Override
    public int getDrBatchWaitingAcknowledgeCount() {
        return this.dr.batchWaitingAcknowledgeCount();
    }

    @Override
    public int getDrSenderHubsCount() {
        return this.dr.senderHubsCount();
    }

    @Override
    public String getDrSenderGroup() {
        return this.dr.getDrSenderGroup();
    }

    @Override
    public String getDrStatus() {
        try {
            CacheDrStatus status = this.dr.metrics0().drSendMetrics().status();
            if (!status.stopped()) {
                return "Active";
            }
            return "Stopped [reason=" + (Object)((Object)status.reason()) + (status.error() == null ? "" : ", error=" + status.error()) + ']';
        }
        catch (IllegalStateException ignored) {
            return "Not configured";
        }
    }

    @Override
    @Deprecated
    public void pause() {
        this.stop();
    }

    @Override
    @Deprecated
    public void resume() {
        this.start();
    }

    @Override
    public void stop() {
        this.dr.stopReplication();
    }

    @Override
    public void start() {
        this.dr.startReplication();
    }

    @Override
    public void transferTo(byte dataCenterId) {
        this.dr.startStateTransfer(Collections.singleton(dataCenterId), false);
    }

    @Override
    public void setStateTransferThrottle(long stateTransferThrottle) {
        this.dr.setStateTransferThrottle(stateTransferThrottle);
    }

    @Override
    public long getStateTransferThrottle() {
        return this.dr.getStateTransferThrottle();
    }

    @Override
    public void disableAdaptiveThrottling() {
        this.dr.disableAdaptiveThrottling();
    }

    @Override
    public void enableAdaptiveThrottling() {
        this.dr.enableAdaptiveThrottling();
    }
}

