/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteProductVersion;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CacheSnapshotMetadata;
import org.jetbrains.annotations.NotNull;

@Deprecated
public final class SnapshotMetadata
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final String FAILED_TO_MERGE_SNAPSHOT_METADATA = "Failed to merge snapshot metadata [oldMeta=";
    private final long id;
    private final UUID initiatorNodeId;
    private final int pageSize;
    private final boolean fullSnapshot;
    private final AffinityTopologyVersion topVer;
    @GridToStringInclude
    private final Collection<ClusterNode> topology;
    private final String msg;
    @GridToStringInclude
    private final Map<Integer, CacheSnapshotMetadata> cacheMetas;
    @GridToStringInclude
    private final Map<Byte, Map<Integer, String>> marshallerMappingsMap = new HashMap<Byte, Map<Integer, String>>();
    final Map<String, Long> sizeOnlyDataInPages;
    final Map<String, Long> sizeInPages;

    public SnapshotMetadata(long id, UUID initiatorNodeId, int pageSize, Map<Byte, Map<Integer, String>> marshallerMappingsMap, boolean fullSnapshot, AffinityTopologyVersion topVer, Collection<ClusterNode> topology, Map<Integer, CacheSnapshotMetadata> cacheMetas, Map<String, Long> sizeOnlyDataInPages, Map<String, Long> sizeInPages, String msg) {
        this.id = id;
        this.initiatorNodeId = initiatorNodeId;
        this.pageSize = pageSize;
        this.marshallerMappingsMap.putAll(marshallerMappingsMap);
        this.fullSnapshot = fullSnapshot;
        this.topVer = topVer;
        this.topology = topology;
        this.cacheMetas = cacheMetas;
        this.sizeOnlyDataInPages = sizeOnlyDataInPages;
        this.sizeInPages = sizeInPages;
        this.msg = msg;
    }

    public long id() {
        return this.id;
    }

    public UUID initiatorNodeId() {
        return this.initiatorNodeId;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public Set<Integer> cacheGroupIds() {
        return new HashSet<Integer>(this.cacheMetas.keySet());
    }

    public Map<Byte, Map<Integer, String>> typeMap() {
        if (this.marshallerMappingsMap == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.marshallerMappingsMap);
    }

    public Map<Integer, CacheSnapshotMetadata> cacheMetadata() {
        return this.cacheMetas;
    }

    public long sizeInPages() {
        if (this.sizeInPages == null) {
            return -1L;
        }
        long size = 0L;
        for (Long s2 : this.sizeInPages.values()) {
            size += s2.longValue();
        }
        return size;
    }

    public long sizeInBytes() {
        long sizeInPages = this.sizeInPages();
        return sizeInPages == -1L ? -1L : sizeInPages * (long)this.pageSize;
    }

    public long sizeOnlyDataInPages() {
        if (this.sizeOnlyDataInPages == null) {
            return -1L;
        }
        long size = 0L;
        for (Long s2 : this.sizeOnlyDataInPages.values()) {
            size += s2.longValue();
        }
        return size;
    }

    public long sizeOnlyDataInBytes() {
        long sizeOnlyDataInPages = this.sizeOnlyDataInPages();
        return sizeOnlyDataInPages == -1L ? -1L : sizeOnlyDataInPages * (long)this.pageSize;
    }

    public Map<Long, Set<String>> previousSnapshots() {
        HashMap<Long, Set<String>> prevSnapshots = new HashMap<Long, Set<String>>();
        if (!F.isEmpty(this.cacheMetas)) {
            for (CacheSnapshotMetadata m4 : this.cacheMetas.values()) {
                Long prevId = m4.previousSnapshotId("");
                if (prevId == null || prevId <= 0L) continue;
                HashSet<String> caches = (HashSet<String>)prevSnapshots.get(prevId);
                if (caches == null) {
                    caches = new HashSet<String>();
                }
                caches.add(m4.cacheOrGroupName());
                prevSnapshots.put(prevId, caches);
            }
        }
        return prevSnapshots;
    }

    public boolean fullSnapshot() {
        return this.fullSnapshot;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public Collection<ClusterNode> topology() {
        return this.topology;
    }

    public String message() {
        return this.msg;
    }

    public Set<IgniteProductVersion> getVersions() {
        HashSet<IgniteProductVersion> versions = new HashSet<IgniteProductVersion>();
        for (ClusterNode node : this.topology) {
            versions.add(node.version());
        }
        return versions;
    }

    @NotNull
    public SnapshotMetadata merge(SnapshotMetadata oldMetadata) throws IgniteCheckedException {
        Map<String, Long> sizeInPages;
        Map<String, Long> sizeOnlyDataInPages;
        if (oldMetadata == null) {
            return this;
        }
        if (oldMetadata.initiatorNodeId() == null || oldMetadata.topologyVersion() == null || !oldMetadata.initiatorNodeId().equals(this.initiatorNodeId()) || oldMetadata.fullSnapshot() != this.fullSnapshot() || oldMetadata.pageSize() != this.pageSize() || !oldMetadata.topologyVersion().equals(this.topologyVersion())) {
            throw new IgniteCheckedException(FAILED_TO_MERGE_SNAPSHOT_METADATA + oldMetadata + ", mergeMeta=" + this + ']');
        }
        Map<Integer, CacheSnapshotMetadata> mergedMetas = oldMetadata.cacheMetadata();
        for (Map.Entry<Integer, CacheSnapshotMetadata> metaEntry : this.cacheMetadata().entrySet()) {
            Integer grpId = metaEntry.getKey();
            CacheSnapshotMetadata oldCacheMeta = mergedMetas.get(grpId);
            assert (oldCacheMeta != null);
            mergedMetas.put(grpId, oldCacheMeta.merge(metaEntry.getValue(), this.getVersions(), false));
        }
        Map<Byte, Map<Integer, String>> marshallerMappings = this.mergeMarshallerMappingsMeta(oldMetadata.marshallerMappingsMap);
        if (this.sizeOnlyDataInPages == null || this.sizeOnlyDataInPages.isEmpty()) {
            sizeOnlyDataInPages = oldMetadata.sizeOnlyDataInPages;
        } else if (oldMetadata.sizeOnlyDataInPages == null || oldMetadata.sizeOnlyDataInPages.isEmpty()) {
            sizeOnlyDataInPages = this.sizeOnlyDataInPages;
        } else {
            sizeOnlyDataInPages = new HashMap<String, Long>(this.sizeOnlyDataInPages);
            sizeOnlyDataInPages.putAll(oldMetadata.sizeOnlyDataInPages);
        }
        if (this.sizeInPages == null || this.sizeInPages.isEmpty()) {
            sizeInPages = oldMetadata.sizeInPages;
        } else if (oldMetadata.sizeInPages == null || oldMetadata.sizeInPages.isEmpty()) {
            sizeInPages = this.sizeInPages;
        } else {
            sizeInPages = new HashMap<String, Long>(this.sizeInPages);
            sizeInPages.putAll(oldMetadata.sizeInPages);
        }
        return new SnapshotMetadata(this.id, oldMetadata.initiatorNodeId(), oldMetadata.pageSize(), marshallerMappings, oldMetadata.fullSnapshot(), oldMetadata.topologyVersion(), oldMetadata.topology(), mergedMetas, sizeOnlyDataInPages, sizeInPages, this.msg);
    }

    private Map<Byte, Map<Integer, String>> mergeMarshallerMappingsMeta(Map<Byte, Map<Integer, String>> oldMappings) {
        Map<Byte, Map<Integer, String>> newMappings = this.marshallerMappingsMap;
        if (newMappings == null) {
            return oldMappings;
        }
        for (Map.Entry<Byte, Map<Integer, String>> newEntry : newMappings.entrySet()) {
            byte platformId = newEntry.getKey();
            if (oldMappings.containsKey(platformId)) {
                oldMappings.get(platformId).putAll(newEntry.getValue());
                continue;
            }
            oldMappings.put(platformId, newEntry.getValue());
        }
        return oldMappings;
    }

    public Set<String> cacheNames() {
        HashSet<String> cacheNames = new HashSet<String>();
        for (CacheSnapshotMetadata cacheMeta : this.cacheMetadata().values()) {
            cacheNames.addAll(cacheMeta.cacheNames());
        }
        return cacheNames;
    }

    public Map<String, CacheMode> cacheModes() {
        HashMap<String, CacheMode> cacheModes = new HashMap<String, CacheMode>();
        for (CacheSnapshotMetadata cacheMeta : this.cacheMetadata().values()) {
            for (CacheConfiguration cfg : cacheMeta.cacheConfigurations()) {
                cacheModes.put(cfg.getName(), cfg.getCacheMode());
            }
        }
        return cacheModes;
    }

    public void prepareMarshal() throws IgniteCheckedException {
        for (CacheSnapshotMetadata cacheSnapshotMetadata : this.cacheMetas.values()) {
            cacheSnapshotMetadata.prepareMarshal();
        }
    }

    public void finishUnmarshal(ClassLoader ldr, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, boolean ignoreMissedClasses) throws IgniteCheckedException {
        for (CacheSnapshotMetadata cacheSnapshotMetadata : this.cacheMetas.values()) {
            cacheSnapshotMetadata.finishUnmarshal(ldr, c, ignoreMissedClasses);
        }
    }

    public String toString() {
        return S.toString(SnapshotMetadata.class, this);
    }

    public Map<String, Integer> cacheNamesWithGroups() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry<Integer, CacheSnapshotMetadata> e : this.cacheMetas.entrySet()) {
            for (CacheConfiguration cfg : e.getValue().cacheConfigurations()) {
                result.put(cfg.getName(), e.getKey());
            }
        }
        return result;
    }
}

