/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadata;

public class SnapshotDescriptor {
    public static final String CLUSTER_WIDE = "<CLUSTER_WIDE>";
    public static final String SNAPSHOT_DIR = "SNAPSHOT_DIR";
    public static final String LOCAL_STORAGE = "<LOCAL>";
    @GridToStringInclude
    protected Map<Object, Map<String, String>> nodeAttributes;
    @GridToStringInclude
    protected SnapshotMetadata snapshotMetadata;

    protected SnapshotDescriptor() {
    }

    public SnapshotDescriptor(SnapshotMetadata snapshotMetadata) {
        this.nodeAttributes = new HashMap<Object, Map<String, String>>();
        this.snapshotMetadata = snapshotMetadata;
    }

    public SnapshotDescriptor(SnapshotMetadata snapshotMetadata, Map<Object, Map<String, String>> mutablePart) {
        this.nodeAttributes = mutablePart;
        this.snapshotMetadata = snapshotMetadata;
    }

    public Map<Object, Map<String, String>> nodeAttributes() {
        return this.nodeAttributes;
    }

    public SnapshotMetadata snapshotMetadata() {
        return this.snapshotMetadata;
    }

    public void addAttribute(Object consistentId, String name, String val) {
        Map<String, String> map = this.nodeAttributes.get(consistentId);
        if (map == null) {
            map = new HashMap<String, String>();
            this.nodeAttributes.put(consistentId, map);
        }
        map.put(name, val);
    }

    public SnapshotDescriptor merge(SnapshotDescriptor detail) throws IgniteCheckedException {
        this.nodeAttributes.putAll(detail.nodeAttributes);
        this.snapshotMetadata = this.snapshotMetadata.merge(detail.snapshotMetadata);
        return this;
    }

    public SnapshotDescriptor merge(SnapshotMetadata metadata) throws IgniteCheckedException {
        this.snapshotMetadata = this.snapshotMetadata.merge(metadata);
        return this;
    }

    public String toString() {
        return S.toString(SnapshotDescriptor.class, this);
    }
}

