/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.persistentstore.SnapshotCommonParams;
import org.jetbrains.annotations.Nullable;

public class SnapshotCommonParameters
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private int snapshotOperationParallelism = 2;

    public SnapshotCommonParameters() {
    }

    public SnapshotCommonParameters(int snapshotOperationParallelism) {
        this.snapshotOperationParallelism = snapshotOperationParallelism;
    }

    @Override
    public void writeExternalData(ObjectOutput out) throws IOException {
        out.writeByte(this.snapshotOperationParallelism);
    }

    @Override
    public void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.snapshotOperationParallelism = in.readByte();
    }

    public int getSnapshotOperationParallelism() {
        return this.snapshotOperationParallelism;
    }

    public String toString() {
        return S.toString(SnapshotCommonParameters.class, this);
    }

    @Nullable
    public static SnapshotCommonParameters convertToSnapshotCommonParameters(@Nullable SnapshotCommonParams snapshotCommonParams) {
        return snapshotCommonParams == null ? null : new SnapshotCommonParameters(snapshotCommonParams.snapshotOperationParallelism());
    }

    @Nullable
    public static SnapshotCommonParams convertToSnapshotCommonParams(@Nullable SnapshotCommonParameters snapshotCommonParameters) {
        return snapshotCommonParameters == null ? null : new SnapshotCommonParams(snapshotCommonParameters.getSnapshotOperationParallelism());
    }
}

