/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.managers.encryption.GroupKeyEncrypted;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperation;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.gridgain.grid.internal.processors.cache.database.SnapshotUpdateOperationParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CustomStagesConfiguration;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.LatestSnapshotMismatchHandlingPolicy;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateTransferParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotEncryptionOptions;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotRestoreStrategy;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotRemotePath;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;
import org.jetbrains.annotations.Nullable;

public class GridSnapshotOperationAttrs {
    public static final String FORCE_RESTORE_KEY = "FORCE_RESTORE_KEY";
    public static final String SNAPSHOT_RESTORE_STRATEGY_KEY = "SNAPSHOT_RESTORE_STRATEGY";
    public static final String POINT_IN_TIME_KEY = "POINT_IN_TIME";
    public static final String SKIP_CRC_KEY = "SKIP_CRC";
    public static final Attr<Collection<File>> OPTIONAL_SEARCH_PATHS_KEY = new Attr("OPTIONAL_PATHS");
    public static final Attr<Collection<SnapshotRemotePath>> OPTIONAL_SEARCH_PATHS_KEY_V2 = new Attr("OPTIONAL_PATHS_V2");
    public static final Attr<File> CREATE_PATH_KEY = new Attr("CREATE_PATH");
    public static final String FULL_SNAPSHOT_KEY = "FULL_SNAPSHOT";
    public static final Attr<File> MOVING_PATH_KEY = new Attr("MOVING_PATH");
    public static final Attr<SnapshotRemotePath> MOVING_PATH_KEY_V2 = new Attr("MOVING_PATH_V2");
    public static final String CONSISTENT_ID_MAPPING_KEY = "CONSISTENT_ID_MAPPING";
    public static final String FORCE_FLAG_KEY = "FORCE_FLAG";
    public static final String SKIP_WAL_MOVE_FLAG_KEY = "SKIP_WAL_MOVE_FLAG";
    public static final String SNAPSHOT_UPDATE_OPERATION_PARAMETERS_KEY = "SNAPSHOT_UPDATE_OPERATION_PARAMS";
    public static final String SNAPSHOT_CREATE_PARAMETERS_KEY = "SNAPSHOT_CREATE_PARAMETERS";
    public static final String REPLICATION_BOOTSTRAP_REPLICA_FLAG = "REPLICATION_BOOTSTRAP_REPLICA_FLAG";
    public static final String REPLICATION_BOOTSTRAP_MASTER_FLAG = "REPLICATION_BOOTSTRAP_MASTER_FLAG";
    public static final String CONISTENT_CUT_TESTING_SNAPSHOT_CREATE = "CONISTENT_CUT_TESTING_SNAPSHOT_CREATE";
    public static final String IMPLICIT_SNAPSHOT_OPERATION = "IMPLICIT_SNAPSHOT_OPERATION";
    public static final String NEED_EXCHANGE_ON_START = "NEED_EXCHANGE_ON_START";
    public static final String REPLICATION_STATE = "REPLICATION_STATE";
    public static final String REPLICATION_SESSION_ID = "REPLICATION_SESSION_ID";
    public static final String REPLICATION_NEW_SESSION_ID = "REPLICATION_NEW_SESSION_ID";
    public static final String REPLICATION_CLUSTER_ROLE = "REPLICATION_CLUSTER_ROLE";
    public static final String REPLICATION_RECOVERY_NODES = "REPLICATION_RECOVERY_NODES";
    public static final String SNAPSHOT_COMMON_PARAMETERS_KEY = "SNAPSHOT_COMMON_PARAMETERS_KEY";
    public static final String SNAPSHOT_SECURITY_LEVEL_KEY = "SNAPSHOT_SECURITY_LEVEL_KEY";
    public static final String SNAPSHOT_ENCRYPTION_OPS = "SNAPSHOT_ENCRYPTION_OPS";
    public static final String SNAPSHOT_RESTORE_ENCRYPTION_KEYS = "SNAPSHOT_RESTORE_ENCRYPTION_KEYS";
    public static final String EXCHANGELESS_SNAPSHOT = "EXCHANGELESS_SNAPSHOT";
    public static final String CUSTOM_STAGES_CONFIGURATION = "CUSTOM_STAGES_CONFIGURATION";

    public static Collection<SnapshotRemotePath> getOptionalPathsParameter(GridSnapshotOperationEx op) {
        return GridSnapshotOperationAttrs.getOptionalPathsParameter(op.type(), op.extraParameter());
    }

    public static Collection<SnapshotRemotePath> getOptionalPathsParameter(SnapshotOperationType opType, Object param) {
        if (param == null) {
            return null;
        }
        switch (opType) {
            case CHECK: 
            case RESTORE: {
                if (param instanceof Collection) {
                    return SnapshotRemotePath.convertToSnapshotPathCollection((Collection)param);
                }
            }
            case RECOVERY: {
                if (!(param instanceof Map)) break;
                Collection<SnapshotRemotePath> paths = OPTIONAL_SEARCH_PATHS_KEY_V2.get((Map)param);
                if (paths != null) {
                    return paths;
                }
                return SnapshotRemotePath.convertToSnapshotPathCollection(OPTIONAL_SEARCH_PATHS_KEY.get((Map)param));
            }
        }
        throw new AssertionError((Object)opType);
    }

    public static SnapshotRestoreStrategy getRestoreStrategy(GridSnapshotOperationEx op) {
        if (op.extraParameter() == null) {
            return null;
        }
        switch (op.type()) {
            case CHECK: 
            case RESTORE: 
            case RECOVERY: {
                assert (op.extraParameter() instanceof Map) : op;
                return (SnapshotRestoreStrategy)((Object)((Map)op.extraParameter()).get(SNAPSHOT_RESTORE_STRATEGY_KEY));
            }
        }
        throw new AssertionError((Object)op.type());
    }

    public static SnapshotRestoreStrategy getRestoreStrategyOrDefault(GridSnapshotOperationEx op, SnapshotRestoreStrategy dfltStgy) {
        assert (dfltStgy != null);
        SnapshotRestoreStrategy stgy = GridSnapshotOperationAttrs.getRestoreStrategy(op);
        return stgy != null ? stgy : dfltStgy;
    }

    public static long getPointInTimeParameter(GridSnapshotOperationEx op) {
        Object param = op.extraParameter();
        assert (op.type() == SnapshotOperationType.RECOVERY && param instanceof Map);
        return (Long)((Map)param).get(POINT_IN_TIME_KEY);
    }

    public static boolean getSkipCrcParameter(GridSnapshotOperationEx op) {
        Object param = op.extraParameter();
        if (param == null) {
            return false;
        }
        assert (op.type() == SnapshotOperationType.CHECK) : op;
        if (param instanceof Map) {
            return (Boolean)((Map)param).get(SKIP_CRC_KEY);
        }
        throw new AssertionError((Object)op.toString());
    }

    public static Boolean getFullSnapshotParameter(GridSnapshotOperationEx op) {
        assert (op.type() == SnapshotOperationType.CREATE) : "Operation type is " + (Object)((Object)op.type());
        Object param = op.extraParameter();
        if (param instanceof T2) {
            return (Boolean)((T2)param).get1();
        }
        if (param instanceof Map) {
            return (Boolean)((Map)param).get(FULL_SNAPSHOT_KEY);
        }
        if (param instanceof Boolean) {
            return (Boolean)param;
        }
        throw new AssertionError((Object)("Unexpected class - " + param.getClass().getName()));
    }

    public static SnapshotEncryptionOptions getEncryptionOptions(GridSnapshotOperationEx op) {
        return GridSnapshotOperationAttrs.getOption(op, SNAPSHOT_ENCRYPTION_OPS, null);
    }

    public static SnapshotEncryptionOptions prepareEncryptionOptions(GridSnapshotOperationEx op, EncryptionSpi spi) {
        Object param = op.extraParameter();
        if (param instanceof Map) {
            SnapshotEncryptionOptions ops = (SnapshotEncryptionOptions)((Map)param).get(SNAPSHOT_ENCRYPTION_OPS);
            if (ops == null) {
                return null;
            }
            ops.decryptEncryptionKeys(spi);
            return ops;
        }
        return null;
    }

    public static void setEncryptionOptions(GridSnapshotOperationEx op, SnapshotEncryptionOptions encryptionOptions) {
        Object param = op.extraParameter();
        if (param instanceof Map) {
            ((Map)param).put(SNAPSHOT_ENCRYPTION_OPS, encryptionOptions);
        }
    }

    public static Map<Integer, GroupKeyEncrypted> getRestoreEncryptionKeys(GridSnapshotOperationEx op) {
        return GridSnapshotOperationAttrs.getOption(op, SNAPSHOT_RESTORE_ENCRYPTION_KEYS, null);
    }

    public static void setRestoreEncryptionKeys(GridSnapshotOperationEx op, Map<Integer, GroupKeyEncrypted> encryptionKeys) {
        Object param = op.extraParameter();
        if (param instanceof Map) {
            ((Map)param).put(SNAPSHOT_RESTORE_ENCRYPTION_KEYS, encryptionKeys);
        }
    }

    public static SnapshotRemotePath getDestinationPathParameter(GridSnapshotOperationEx op) {
        assert (op.type() == SnapshotOperationType.MOVE || op.type() == SnapshotOperationType.COPY) : op;
        Object param = op.extraParameter();
        if (param instanceof Map) {
            SnapshotRemotePath path = MOVING_PATH_KEY_V2.get((Map)param);
            if (path != null) {
                return path;
            }
            return new SnapshotRemotePath(MOVING_PATH_KEY.get((Map)param));
        }
        if (param instanceof File) {
            return new SnapshotRemotePath((File)param);
        }
        throw new AssertionError((Object)("Unexpected class - " + param.getClass().getName()));
    }

    @Nullable
    public static File getCreatePathParameter(GridSnapshotOperationEx op) {
        assert (op.type() == SnapshotOperationType.CREATE);
        Object param = op.extraParameter();
        if (param instanceof T2) {
            return (File)((T2)param).get2();
        }
        if (param instanceof Map) {
            return CREATE_PATH_KEY.get((Map)param);
        }
        if (param instanceof Boolean) {
            return null;
        }
        throw new AssertionError(op);
    }

    public static boolean getRestoreForceOption(GridSnapshotOperationEx op) {
        assert (op.type() == SnapshotOperationType.RESTORE || op.type() == SnapshotOperationType.RECOVERY || op.type() == SnapshotOperationType.CHECK);
        if (op.extraParameter() instanceof Map) {
            Map map = (Map)op.extraParameter();
            Boolean forceOpt = (Boolean)map.get(FORCE_RESTORE_KEY);
            return forceOpt != null ? forceOpt : false;
        }
        return false;
    }

    public static boolean getForceFlag(GridSnapshotOperationEx op) {
        assert (op.type() == SnapshotOperationType.DELETE);
        if (op.extraParameter() instanceof Map) {
            Map map = (Map)op.extraParameter();
            return (Boolean)map.get(FORCE_FLAG_KEY);
        }
        return (Boolean)op.extraParameter();
    }

    public static int getSnapshotOperationParallelism(GridSnapshotOperationEx op) {
        Object param = op.extraParameter();
        if (param instanceof Map && ((Map)param).get(SNAPSHOT_COMMON_PARAMETERS_KEY) != null) {
            SnapshotCommonParameters snapshotCommonParameters = (SnapshotCommonParameters)((Map)param).get(SNAPSHOT_COMMON_PARAMETERS_KEY);
            return snapshotCommonParameters.getSnapshotOperationParallelism();
        }
        return 2;
    }

    public static String getSnapshotLabel(GridSnapshotOperationEx op) {
        Object param = op.extraParameter();
        if (param instanceof Map && ((Map)param).get(SNAPSHOT_CREATE_PARAMETERS_KEY) != null) {
            SnapshotCreateParameters snapshotCommonParameters = (SnapshotCreateParameters)((Map)param).get(SNAPSHOT_CREATE_PARAMETERS_KEY);
            return snapshotCommonParameters.getSnapshotLabel();
        }
        return "";
    }

    public static boolean getSkipWalParameter(GridSnapshotOperationEx op) {
        assert (op.type() == SnapshotOperationType.MOVE || op.type() == SnapshotOperationType.COPY) : op;
        Object param = op.extraParameter();
        return param instanceof Map && Boolean.TRUE.equals(((Map)param).get(SKIP_WAL_MOVE_FLAG_KEY));
    }

    public static boolean getNeedExchangeOnStart(GridSnapshotOperationEx op) {
        Object param = op.extraParameter();
        return param instanceof Map && Boolean.TRUE.equals(((Map)param).get(NEED_EXCHANGE_ON_START));
    }

    public static boolean getReplicationBootstrapReplicaFlag(GridSnapshotOperationEx op) {
        assert (op.type() == SnapshotOperationType.RESTORE || op.type() == SnapshotOperationType.RECOVERY) : op;
        Object param = op.extraParameter();
        return param instanceof Map && Boolean.TRUE.equals(((Map)param).get(REPLICATION_BOOTSTRAP_REPLICA_FLAG));
    }

    public static boolean getReplicationBootstrapMasterFlag(GridSnapshotOperationEx op) {
        assert (op.type() == SnapshotOperationType.CREATE);
        Object param = op.extraParameter();
        return param instanceof Map && Boolean.TRUE.equals(((Map)param).get(REPLICATION_BOOTSTRAP_MASTER_FLAG));
    }

    public static boolean getConsistentCutTestingSnapshotCreateFlag(GridSnapshotOperationEx op) {
        assert (op.type() == SnapshotOperationType.CREATE);
        Object param = op.extraParameter();
        return param instanceof Map && Boolean.TRUE.equals(((Map)param).get(CONISTENT_CUT_TESTING_SNAPSHOT_CREATE));
    }

    public static int getReplicationState(GridSnapshotOperationEx op) {
        assert (op.type() == SnapshotOperationType.REPLICATION_STATE_CHANGE) : op;
        Object param = op.extraParameter();
        assert (param instanceof Map);
        return (Integer)((Map)param).get(REPLICATION_STATE);
    }

    public static long getReplicationSessionId(GridSnapshotOperationEx op) {
        assert (op.type() == SnapshotOperationType.REPLICATION_STATE_CHANGE || op.type() == SnapshotOperationType.REPLICATION_RECOVERY) : op;
        Object param = op.extraParameter();
        assert (param instanceof Map);
        return (Long)((Map)param).get(REPLICATION_SESSION_ID);
    }

    public static Long getReplicationNewSessionId(GridSnapshotOperationEx op) {
        assert (op.type() == SnapshotOperationType.REPLICATION_STATE_CHANGE);
        Object param = op.extraParameter();
        assert (param instanceof Map);
        return (Long)((Map)param).get(REPLICATION_NEW_SESSION_ID);
    }

    public static int getReplicationClusterRole(GridSnapshotOperationEx op) {
        assert (op.type() == SnapshotOperationType.REPLICATION_STATE_CHANGE) : op;
        Object param = op.extraParameter();
        assert (param instanceof Map);
        return (Integer)((Map)param).get(REPLICATION_CLUSTER_ROLE);
    }

    public static Set<UUID> getReplicationRecoveryNodes(GridSnapshotOperationEx op) {
        assert (op.type() == SnapshotOperationType.REPLICATION_RECOVERY) : op;
        Object param = op.extraParameter();
        assert (param instanceof Map);
        return (Set)((Map)param).get(REPLICATION_RECOVERY_NODES);
    }

    public static CompressionOption getCompressionOptionParameter(GridSnapshotOperationEx op) {
        CompressionOption compressionOption;
        assert (op.type() == SnapshotOperationType.CREATE) : op;
        Object param = op.extraParameter();
        if (param instanceof Map && ((Map)param).get(SNAPSHOT_CREATE_PARAMETERS_KEY) != null) {
            SnapshotCreateParameters snapshotCreateParameters = (SnapshotCreateParameters)((Map)param).get(SNAPSHOT_CREATE_PARAMETERS_KEY);
            compressionOption = snapshotCreateParameters.getCompressionOption();
        } else {
            compressionOption = CompressionOption.NONE;
        }
        return compressionOption != null ? compressionOption : CompressionOption.NONE;
    }

    public static int getCompressionLevel(GridSnapshotOperationEx op) {
        int compressionLevel;
        assert (op.type() == SnapshotOperationType.CREATE) : op;
        Object param = op.extraParameter();
        if (param instanceof Map && ((Map)param).get(SNAPSHOT_CREATE_PARAMETERS_KEY) != null) {
            SnapshotCreateParameters snapshotCreateParameters = (SnapshotCreateParameters)((Map)param).get(SNAPSHOT_CREATE_PARAMETERS_KEY);
            compressionLevel = snapshotCreateParameters.getCompressionLevel();
            CompressionOption compressionOption = snapshotCreateParameters.getCompressionOption();
            if (compressionLevel == -1) {
                compressionLevel = compressionOption.defaultCompressionLevel();
            }
        } else {
            compressionLevel = 1;
        }
        return compressionLevel;
    }

    public static LatestSnapshotMismatchHandlingPolicy getMismatchHandlingPolicy(GridSnapshotOperationEx op) {
        SnapshotCreateParameters snapshotCreateParameters;
        LatestSnapshotMismatchHandlingPolicy mismatchHandlingPlc;
        assert (op.type() == SnapshotOperationType.CREATE) : op;
        Object param = op.extraParameter();
        if (param instanceof Map && ((Map)param).get(SNAPSHOT_CREATE_PARAMETERS_KEY) != null && (mismatchHandlingPlc = (snapshotCreateParameters = (SnapshotCreateParameters)((Map)param).get(SNAPSHOT_CREATE_PARAMETERS_KEY)).getMismatchHandlingPlc()) != null) {
            return mismatchHandlingPlc;
        }
        return LatestSnapshotMismatchHandlingPolicy.DEFAULT;
    }

    public static int getWriteThrottlingThreshold(GridSnapshotOperationEx op) {
        assert (op.type() == SnapshotOperationType.CREATE) : op;
        Object param = op.extraParameter();
        if (param instanceof Map && ((Map)param).get(SNAPSHOT_CREATE_PARAMETERS_KEY) != null) {
            SnapshotCreateParameters snapshotCreateParameters = (SnapshotCreateParameters)((Map)param).get(SNAPSHOT_CREATE_PARAMETERS_KEY);
            return snapshotCreateParameters.getWriteThrottlingThreshold();
        }
        return 0;
    }

    public static SnapshotCreateTransferParameters getCreateTransferParameters(GridSnapshotOperationEx op) {
        assert (op.type() == SnapshotOperationType.CREATE) : op;
        Object o = op.extraParameter();
        if (o instanceof Map) {
            Map map = (Map)o;
            Object obj = map.get(SNAPSHOT_CREATE_PARAMETERS_KEY);
            if (obj == null) {
                return null;
            }
            assert (obj instanceof SnapshotCreateTransferParameters) : "class=" + obj.getClass() + ", obj=" + obj;
            return (SnapshotCreateTransferParameters)obj;
        }
        return null;
    }

    public static SnapshotUpdateOperationParameters getUpdateOperationsParameters(GridSnapshotOperationEx op) {
        Object o = op.extraParameter();
        if (o instanceof Map) {
            Map map = (Map)o;
            Object obj = map.get(SNAPSHOT_UPDATE_OPERATION_PARAMETERS_KEY);
            if (obj == null) {
                return null;
            }
            assert (obj instanceof SnapshotUpdateOperationParameters) : "class=" + obj.getClass() + ", obj=" + obj;
            return (SnapshotUpdateOperationParameters)obj;
        }
        return null;
    }

    public static SnapshotSecurityLevel getSecurityLevel(GridSnapshotOperationEx op) {
        Object o = op.extraParameter();
        if (o instanceof Map) {
            Map map = (Map)o;
            Object obj = map.get(SNAPSHOT_SECURITY_LEVEL_KEY);
            if (obj == null) {
                return SnapshotSecurityLevel.DISABLED;
            }
            assert (obj instanceof String) : "class=" + obj.getClass() + ", obj=" + obj;
            try {
                return SnapshotSecurityLevel.valueOf(obj.toString());
            }
            catch (IllegalArgumentException e) {
                throw new IgniteException("Unknown value of security level: '" + obj.toString() + "'", e);
            }
        }
        return SnapshotSecurityLevel.DISABLED;
    }

    public static boolean isForAllCaches(GridSnapshotOperationEx op) {
        assert (op.type() == SnapshotOperationType.CREATE) : op;
        Object param = op.extraParameter();
        SnapshotCreateParameters createParameters = !(param instanceof Map) ? null : (SnapshotCreateParameters)((Map)param).get(SNAPSHOT_CREATE_PARAMETERS_KEY);
        return createParameters != null && createParameters.allCaches();
    }

    public static boolean exchangelessSnapshot(SnapshotOperation op) {
        return GridSnapshotOperationAttrs.getBoolean(op, EXCHANGELESS_SNAPSHOT, null);
    }

    public static boolean implicitSnapshotOperation(SnapshotOperation op) {
        return GridSnapshotOperationAttrs.getBoolean(op, IMPLICIT_SNAPSHOT_OPERATION, null);
    }

    @Nullable
    public static CustomStagesConfiguration customStagesConfiguration(SnapshotOperation op) {
        if (op.extraParameter() instanceof Map) {
            Map map = (Map)op.extraParameter();
            Object customStagesConfiguration = map.get(CUSTOM_STAGES_CONFIGURATION);
            if (customStagesConfiguration instanceof CustomStagesConfiguration) {
                return (CustomStagesConfiguration)customStagesConfiguration;
            }
            throw new IgniteException("Incorrect stages configuration [stages=" + customStagesConfiguration + "]");
        }
        return null;
    }

    private static boolean getBoolean(SnapshotOperation op, String paramName, BooleanSupplier dfltValSupplier) {
        Map map;
        Boolean param;
        if (op.extraParameter() instanceof Map && (param = (Boolean)(map = (Map)op.extraParameter()).get(paramName)) != null) {
            return param;
        }
        return dfltValSupplier != null && dfltValSupplier.getAsBoolean();
    }

    public static <T> T getOption(SnapshotOperation op, String paramName, T dflt) {
        Map map;
        Object param;
        if (op.extraParameter() instanceof Map && (param = (map = (Map)op.extraParameter()).get(paramName)) != null) {
            return (T)param;
        }
        return dflt;
    }

    public static class Attr<T> {
        private final String key;

        public Attr(String key) {
            this.key = key;
        }

        public void put(Map<String, ? super T> map, T value) {
            map.put(this.key, value);
        }

        public T get(Map<String, ?> map) {
            return (T)map.get(this.key);
        }
    }
}

