/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.cache;

import java.util.UUID;
import javax.cache.Cache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.EntryCompressionConfiguration;
import org.apache.ignite.internal.processors.cache.CacheConflictResolutionManager;
import org.apache.ignite.internal.processors.cache.CacheInvokeEntry;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.dr.GridCacheReplicationManager;
import org.apache.ignite.internal.processors.cache.dr.GridOsCacheDrManager;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionedEntryEx;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.plugin.CachePluginContext;
import org.apache.ignite.plugin.CachePluginProvider;
import org.gridgain.grid.cache.conflict.CacheConflictEntry;
import org.gridgain.grid.cache.conflict.CacheConflictMode;
import org.gridgain.grid.cache.dr.CacheDrSenderConfiguration;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.GridPluginProvider;
import org.gridgain.grid.internal.GridPluginUtils;
import org.gridgain.grid.internal.processors.cache.conflict.CacheConflictEntryImpl;
import org.gridgain.grid.internal.processors.cache.conflict.CacheEntConflictResolutionManager;
import org.gridgain.grid.internal.processors.cache.dr.GridGainCacheDrManager;
import org.gridgain.grid.internal.processors.cache.dr.ist.GridGainCacheIncrementalDrManager;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.jetbrains.annotations.Nullable;

public class GridCachePluginProvider
implements CachePluginProvider<GridGainCacheConfiguration> {
    private final boolean IS_INCREMENTAL_DR_ENABLED = DrUtils.isIncrementalDrEnabled();
    private final GridPluginProvider provider;
    private final CachePluginContext<GridGainCacheConfiguration> ctx;
    private final IgniteLogger log;
    private GridGainCacheConfiguration ggCcfg;

    public GridCachePluginProvider(GridPluginProvider provider, CachePluginContext ctx) {
        this.provider = provider;
        this.ctx = ctx;
        this.log = ctx.log(this.getClass());
        this.ggCcfg = GridCacheUtils.cachePluginConfiguration(ctx.igniteCacheConfiguration(), GridGainCacheConfiguration.class);
    }

    @Override
    public void start() throws IgniteCheckedException {
    }

    @Override
    public void stop(boolean cancel) {
    }

    @Override
    public void onIgniteStart() {
    }

    @Override
    public void onIgniteStop(boolean cancel) {
    }

    @Override
    @Nullable
    public <T> T createComponent(Class<T> cls) {
        GridGainConfiguration cfg = GridPluginUtils.gridPluginConfiguration(this.ctx.igniteConfiguration());
        if (cls.equals(GridCacheReplicationManager.class)) {
            if (DrUtils.isDrEnabled(cfg) && !CU.isSystemCache(this.ctx.igniteCacheConfiguration().getName())) {
                return (T)(this.IS_INCREMENTAL_DR_ENABLED ? new GridGainCacheIncrementalDrManager(this.ctx, this.provider.dr()) : new GridGainCacheDrManager(this.ctx, this.provider.dr()));
            }
            return (T)new GridOsCacheDrManager();
        }
        if (cls.equals(CacheConflictResolutionManager.class)) {
            return (T)new CacheEntConflictResolutionManager(this.ctx);
        }
        return null;
    }

    @Override
    @Nullable
    public <T, K, V> T unwrapCacheEntry(Cache.Entry<K, V> entry, Class<T> cls) {
        if (cls.isAssignableFrom(CacheConflictEntry.class) && entry instanceof CacheInvokeEntry) {
            CacheInvokeEntry invokeEntry = (CacheInvokeEntry)entry;
            try {
                GridCacheVersionedEntryEx verEntry = invokeEntry.entry().versionedEntry(invokeEntry.keepBinary());
                CacheObjectContext coctx = invokeEntry.entry().context().cacheObjectContext();
                return (T)new CacheConflictEntryImpl(coctx, verEntry);
            }
            catch (IgniteCheckedException | GridCacheEntryRemovedException e) {
                throw new IgniteException("Failed to unwrap entry: " + entry, e);
            }
        }
        return null;
    }

    @Override
    public void validate() {
        boolean hasVectorIndex;
        CacheConfiguration ccfg = this.ctx.igniteCacheConfiguration();
        EntryCompressionConfiguration compressionCfg = ccfg.getEntryCompressionConfiguration();
        if (compressionCfg != null) {
            IgniteClosure strategyFactory = this.provider.strategies().get(compressionCfg.getClass());
            if (strategyFactory == null) {
                throw new IgniteException("Entry compression is enabled but implementation was not found, check that gridgain-compress module is present on all nodes  [cacheName=" + ccfg.getName() + ", entryCompressionCfg=" + compressionCfg + "]");
            }
            if (this.provider.configuration().getSnapshotConfiguration() != null && !strategyFactory.apply(compressionCfg).stateless()) {
                throw new IgniteException("Only stateless compression is supported when snapshots are used [cacheName=" + ccfg.getName() + ", entryCompressionCfg=" + compressionCfg + "]");
            }
            if (!this.provider.compressionLicense()) {
                throw new IgniteException("Entry compression is not allowed by the licence [cacheName=" + ccfg.getName() + "]");
            }
        }
        if ((hasVectorIndex = ccfg.getQueryEntities().stream().flatMap(entity -> entity.getIndexes().stream()).filter(idx -> idx.getIndexType() == QueryIndexType.VECTOR).findAny().isPresent()) && !this.provider.vectorSearchLicense()) {
            throw new IgniteException("Vector search is not allowed by the licence [cacheName=" + ccfg.getName() + "]");
        }
        if (this.ggCcfg != null) {
            CacheConflictMode rslvrMode = this.ggCcfg.getConflictResolverMode();
            if (rslvrMode == CacheConflictMode.ALWAYS && this.ggCcfg.getConflictResolver() == null) {
                throw new IgniteException("Conflict resolver must be not null with " + (Object)((Object)rslvrMode) + " resolving policy");
            }
            if (DrUtils.isDrEnabled(this.provider.configuration())) {
                CacheDrSenderConfiguration drSndCfg = this.ggCcfg.getDrSenderConfiguration();
                if (drSndCfg != null) {
                    if (ccfg.getCacheMode() == CacheMode.LOCAL) {
                        throw new IgniteException("Data center replication is not supported for LOCAL cache");
                    }
                    this.assertParameter(drSndCfg.getBatchSendSize() >= 0, "cfg.getDrSenderConfiguration().getBatchSendSize() >= 0");
                    this.assertParameter(this.provider.configuration().getBatchSendSizeBytes() >= 0, "ggCfg.getBatchSendSizeBytes() >= 0");
                    this.assertParameter(drSndCfg.getBatchSendSize() > 0 || this.provider.configuration().getBatchSendSizeBytes() > 0, "ggCfg.getBatchSendSizeBytes() > 0 or cfg.getDrSenderConfiguration().getBatchSendSize() > 0");
                    if (drSndCfg.getBatchSendFrequency() < 0L) {
                        drSndCfg.setBatchSendFrequency(0L);
                    }
                    this.assertParameter(drSndCfg.getLoadBalancingMode() != null, "cfg.getDrSenderConfiguration().getLoadBalancingMode() != null");
                    this.assertParameter(drSndCfg.getStateTransferThreadsCount() > 0, "cfg.getDrSenderConfiguration().getStateTransferThreadsCount() > 0");
                    this.assertParameter(drSndCfg.getStateTransferThrottle() >= 0L, "cfg.getDrSenderConfiguration().getStateTransferThrottle >= 0");
                    this.assertParameter(drSndCfg.getStateTransferThrottleBytes() >= 0, "cfg.getDrSenderConfiguration().getStateTransferThrottleBytes >= 0");
                }
                if (ccfg.getCacheMode() != CacheMode.LOCAL) {
                    this.assertParameter(rslvrMode != null, "cfg.getConflictResolverMode() != null");
                }
            }
        }
    }

    private void assertParameter(boolean cond, String condDesc) {
        if (!cond) {
            throw new IgniteException("GridGain cache plugin configuration parameter invalid: " + condDesc);
        }
    }

    @Override
    public void validateRemote(CacheConfiguration locCfg, CacheConfiguration rmtCfg, ClusterNode rmt) throws IgniteCheckedException {
        GridGainCacheConfiguration rmtPluginCcfg = GridCacheUtils.cachePluginConfiguration(rmtCfg, GridGainCacheConfiguration.class);
        if (rmtPluginCcfg != null && this.ggCcfg != null) {
            CacheDrSenderConfiguration locSndCfg = this.ggCcfg.getDrSenderConfiguration();
            CacheDrSenderConfiguration rmtSndCfg = rmtPluginCcfg.getDrSenderConfiguration();
            if (locSndCfg != null && rmtSndCfg != null) {
                CU.checkAttributeMismatch(this.log, rmtCfg.getName(), rmt.id(), "entryFilterClassName", "Class name for replication cache entry filter", GridCachePluginProvider.className(locSndCfg.getEntryFilter()), GridCachePluginProvider.className(rmtSndCfg.getEntryFilter()), true);
            } else if (locSndCfg != null || rmtSndCfg != null) {
                UUID nullAttrNode = locSndCfg == null ? this.ctx.localNode().id() : rmt.id();
                throw new IgniteCheckedException("Replication sender cache should be enabled for all nodes or disabled for all of them (configuration is not set for nodeId=" + nullAttrNode + ").");
            }
            if (this.ggCcfg.isDrReceiverEnabled() != rmtPluginCcfg.isDrReceiverEnabled()) {
                UUID nullAttrNode = !this.ggCcfg.isDrReceiverEnabled() ? this.ctx.localNode().id() : rmt.id();
                throw new IgniteCheckedException("DR receiver cache should be enabled for all nodes or disabled for all of them (configuration is not set for nodeId=" + nullAttrNode + ").");
            }
            CU.checkAttributeMismatch(this.log, rmtCfg.getName(), rmt.id(), "conflictResolverPolicy", "Policy for conflict resolver", (Object)this.ggCcfg.getConflictResolverMode(), (Object)rmtPluginCcfg.getConflictResolverMode(), true);
            CU.checkAttributeMismatch(this.log, rmtCfg.getName(), rmt.id(), "conflictResolverClassName", "Class name for conflict resolver", GridCachePluginProvider.className(this.ggCcfg.getConflictResolver()), GridCachePluginProvider.className(rmtPluginCcfg.getConflictResolver()), true);
        }
    }

    @Nullable
    private static String className(@Nullable Object obj) {
        return obj != null ? obj.getClass().getName() : null;
    }
}

