/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.dr.store.memory;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.gridgain.grid.dr.store.DrAbstractSenderStore;
import org.gridgain.grid.dr.store.DrSenderStoreCursor;
import org.gridgain.grid.dr.store.DrSenderStoreEntry;
import org.gridgain.grid.dr.store.DrSenderStoreOverflowMode;
import org.jetbrains.annotations.Nullable;

public class DrSenderInMemoryStore
extends DrAbstractSenderStore
implements LifecycleAware {
    public static final int DFLT_MAX_SIZE = 0x100000;
    private int maxSize = 0x100000;
    private final AtomicLong idGen = new AtomicLong();
    private final ReentrantLock lock = new ReentrantLock();
    private final Entry DUMMY = new Entry(-1L, null, 0, 0L, null);
    private Entry head;
    private Entry tail;
    private int totalCnt;
    private long totalBytes;

    public int getMaxSize() {
        return this.maxSize;
    }

    public DrSenderInMemoryStore setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    @Override
    public DrSenderInMemoryStore setOverflowMode(DrSenderStoreOverflowMode overflowMode) {
        super.setOverflowMode(overflowMode);
        return this;
    }

    @Override
    public void start() {
        A.notNull((Object)this.overflowMode, "overflowMode");
        if (this.maxSize <= 0) {
            this.maxSize = 0;
        }
        assert (this.overflowMode == DrSenderStoreOverflowMode.STOP || this.overflowMode == DrSenderStoreOverflowMode.REMOVE_OLDEST);
        this.reset();
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store0(byte[] dcIds, byte[] data, int cnt, @Nullable IgniteUuid fstId) throws IgniteCheckedException {
        this.lock.lock();
        try {
            if (this.maxSize > 0 && this.totalCnt + cnt > this.maxSize && this.overflowMode == DrSenderStoreOverflowMode.STOP) {
                this.onOverflow();
            }
            Entry entry = new Entry(this.idGen.incrementAndGet(), data, cnt, DrSenderInMemoryStore.dataCenterIdsToMask(dcIds), fstId);
            this.link(entry);
            if (this.maxSize > 0) {
                boolean evicted = false;
                while (this.totalCnt > this.maxSize && this.head != entry) {
                    this.unlink(this.head);
                    evicted = true;
                }
                if (evicted) {
                    assert (this.overflowMode == DrSenderStoreOverflowMode.REMOVE_OLDEST);
                    this.onOverflow();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public DrSenderStoreCursor cursor0(byte dataCenterId) throws IgniteCheckedException {
        this.lock.lock();
        try {
            Cursor cursor = new Cursor(dataCenterId);
            return cursor;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear0() throws IgniteCheckedException {
        this.reset();
    }

    @Override
    public long sizeBytes() {
        this.lock.lock();
        try {
            long l = this.totalBytes;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void reset() {
        this.lock.lock();
        try {
            Entry cur = this.head;
            while (cur != null) {
                Entry next = cur.next;
                cur.doUnlink();
                cur = next;
            }
            assert (this.DUMMY.prev == null);
            this.DUMMY.next = null;
            this.head = this.tail = this.DUMMY;
            this.totalCnt = 0;
            this.totalBytes = 0L;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void link(Entry entry) {
        assert (this.lock.isHeldByCurrentThread());
        assert (entry != null);
        assert (this.head != null);
        assert (this.tail != null);
        assert (this.tail.next == null);
        this.tail.next = entry;
        entry.prev = this.tail;
        this.tail = entry;
        if (this.head == this.DUMMY) {
            this.head = entry;
        }
        this.totalCnt += entry.entryCnt;
        this.totalBytes += (long)entry.data.length;
    }

    private void unlink(Entry entry) {
        assert (this.lock.isHeldByCurrentThread());
        assert (entry != null);
        if (!entry.unlinked) {
            Entry prev = entry.prev;
            Entry next = entry.next;
            if (next == null) {
                assert (entry == this.tail);
            } else {
                next.prev = prev;
                if (prev != null) {
                    prev.next = next;
                }
            }
            int entryCnt = entry.entryCnt;
            int dataLength = entry.data == null ? 0 : entry.data.length;
            entry.doUnlink();
            this.totalCnt -= entryCnt;
            this.totalBytes -= (long)dataLength;
        }
        while (this.head.unlinked && this.head.next != null) {
            this.head = this.head.next;
        }
    }

    private static long dataCenterIdToMask(byte dcId) {
        return 1L << dcId;
    }

    private static long dataCenterIdsToMask(byte[] dcIds) {
        long res = 0L;
        for (byte dcId : dcIds) {
            res |= DrSenderInMemoryStore.dataCenterIdToMask(dcId);
        }
        return res;
    }

    public String toString() {
        return S.toString(DrSenderInMemoryStore.class, this);
    }

    private static class EntryProxy
    implements DrSenderStoreEntry {
        private final Entry entry;
        private final byte[] data;

        public EntryProxy(Entry entry) {
            this.entry = entry;
            this.data = entry.data;
        }

        @Override
        public byte[] data() {
            return this.data;
        }

        @Override
        public void acknowledge(byte dcId) {
            this.entry.acknowledge(dcId);
        }

        @Override
        public IgniteUuid stateTransferId() {
            return this.entry.stateTransferId();
        }

        public String toString() {
            return S.toString(EntryProxy.class, this);
        }
    }

    private class Entry {
        private final long id;
        private final int entryCnt;
        private byte[] data;
        private long dcMask;
        @GridToStringExclude
        private Entry next;
        @GridToStringExclude
        private Entry prev;
        private boolean unlinked;
        private IgniteUuid fstId;

        public Entry(long id, byte[] data, int entryCnt, @Nullable long dcMask, IgniteUuid fstId) {
            this.id = id;
            this.data = data;
            this.entryCnt = entryCnt;
            this.dcMask = dcMask;
            this.fstId = fstId;
        }

        public void acknowledge(byte dcId) {
            DrSenderInMemoryStore.this.lock.lock();
            try {
                if (this.dcMask != 0L) {
                    this.dcMask ^= DrSenderInMemoryStore.dataCenterIdToMask(dcId);
                    if (this.dcMask == 0L) {
                        DrSenderInMemoryStore.this.unlink(this);
                    }
                }
            }
            finally {
                DrSenderInMemoryStore.this.lock.unlock();
            }
        }

        private void doUnlink() {
            this.data = null;
            this.prev = null;
            this.unlinked = true;
        }

        public IgniteUuid stateTransferId() {
            return this.fstId;
        }

        public String toString() {
            return S.toString(Entry.class, this);
        }
    }

    private class Cursor
    implements DrSenderStoreCursor {
        private final long mask;
        private Entry last;
        private long lastCheckedId;

        private Cursor(byte dcId) {
            assert (DrSenderInMemoryStore.this.lock.isHeldByCurrentThread());
            this.mask = DrSenderInMemoryStore.dataCenterIdToMask(dcId);
        }

        private boolean matches(Entry entry) {
            boolean res;
            assert (entry != null);
            boolean bl = res = entry.id > this.lastCheckedId && (entry.dcMask & this.mask) == this.mask && !entry.unlinked;
            if (entry.id > this.lastCheckedId) {
                this.lastCheckedId = entry.id;
            }
            return res;
        }

        @Override
        @Nullable
        public DrSenderStoreEntry next() throws IgniteCheckedException {
            DrSenderInMemoryStore.this.lock.lock();
            try {
                if (this.last == null) {
                    this.last = DrSenderInMemoryStore.this.head;
                    assert (this.last != null);
                    if (this.matches(this.last)) {
                        DrSenderStoreEntry drSenderStoreEntry = this.proxy(this.last);
                        return drSenderStoreEntry;
                    }
                }
                assert (this.last != null);
                Entry res = null;
                while (res == null && this.last.next != null) {
                    if (this.matches(this.last.next)) {
                        res = this.last.next;
                    }
                    this.last = this.last.next;
                }
                DrSenderStoreEntry drSenderStoreEntry = this.proxy(res);
                return drSenderStoreEntry;
            }
            finally {
                DrSenderInMemoryStore.this.lock.unlock();
            }
        }

        private DrSenderStoreEntry proxy(@Nullable Entry entry) {
            assert (DrSenderInMemoryStore.this.lock.isHeldByCurrentThread());
            assert (entry == null || entry.data != null);
            return entry != null ? new EntryProxy(entry) : null;
        }

        @Override
        public void close() throws IgniteCheckedException {
        }

        public String toString() {
            return S.toString(Cursor.class, this);
        }
    }
}

