/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.store.local;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.cache.Cache;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.cache.store.CacheStoreSession;
import org.apache.ignite.internal.processors.cache.CacheEntryImpl;
import org.apache.ignite.internal.processors.cache.store.CacheLocalStore;
import org.apache.ignite.internal.util.GridAtomicInitializer;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.apache.ignite.resources.CacheNameResource;
import org.apache.ignite.resources.CacheStoreSessionResource;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.transactions.Transaction;
import org.gridgain.grid.cache.store.local.CacheFileLocalStoreWriteMode;
import org.gridgain.grid.internal.processors.cache.store.local.CacheFileLocalStoreFileManager;
import org.gridgain.grid.internal.util.GridUtils;
import org.jetbrains.annotations.Nullable;

@CacheLocalStore
public class CacheFileLocalStore<K, V>
implements CacheStore<K, IgniteBiTuple<V, ?>>,
LifecycleAware {
    public static final int DFLT_FSYNC_DELAY = 500;
    public static final int DFLT_WRITE_DELAY = 5000;
    public static final CacheFileLocalStoreWriteMode DFLT_COMMIT_MODE = CacheFileLocalStoreWriteMode.ASYNC_BUFFERED;
    public static final int DFLT_WRITE_BUFFER_SIZE = 131072;
    public static final int DFLT_READ_BUFFER_SIZE = 1024;
    public static final long DFLT_SPARSITY_CHECK_FREQUENCY = 500L;
    public static final int DFLT_COMPACT_BUFFER_SIZE = 262144;
    public static final int DFLT_MAP_CAPACITY = 16384;
    public static final int DFLT_MAP_SEGMENTS = 32;
    public static final float DFLT_MAX_SPARSITY = 0.35f;
    public static final long DFLT_MIN_COMPACT_SIZE = 0x6400000L;
    public static final boolean DFLT_USE_CONSISTENT_ID = true;
    public static final String DFLT_ROOT_PATH = "localstore";
    private static final String TX_DELTA_META_KEY = "store-tx-delta";
    private final GridAtomicInitializer<CacheFileLocalStoreFileManager> space = new GridAtomicInitializer();
    @IgniteInstanceResource
    @GridToStringExclude
    protected Ignite ignite;
    @CacheNameResource
    protected String cacheName;
    @CacheStoreSessionResource
    private CacheStoreSession ses;
    @LoggerResource
    protected IgniteLogger log;
    private volatile boolean stopping;
    int writeBufSize = 131072;
    int readBufSize = 1024;
    int compactBufSize = 262144;
    long sparsityCheckFreq = 500L;
    long fsyncDelay = 500L;
    long writeDelay = 5000L;
    CacheFileLocalStoreWriteMode writeMode = DFLT_COMMIT_MODE;
    float maxSparsity = 0.35f;
    long minCompactSize = 0x6400000L;
    boolean checksum;
    int mapCap = 16384;
    int mapSegments = 32;
    private String rootPath = "localstore";
    private boolean useConsistentId = true;
    Path root;

    public int getWriteBufferSize() {
        return this.writeBufSize;
    }

    public void setWriteBufferSize(int writeBufSize) {
        A.ensure(writeBufSize >= 40, "writeBufSize >= 40");
        this.writeBufSize = writeBufSize;
    }

    public int getReadBufferSize() {
        return this.readBufSize;
    }

    public void setReadBufferSize(int readBufSize) {
        A.ensure(readBufSize >= 40, "readBufSize >= 40");
        this.readBufSize = readBufSize;
    }

    public int getCompactBufferSize() {
        return this.compactBufSize;
    }

    public void setCompactBufferSize(int compactBufSize) {
        A.ensure(compactBufSize >= 40, "compactBufSize >= 40");
        this.compactBufSize = compactBufSize;
    }

    public long getSparsityCheckFrequency() {
        return this.sparsityCheckFreq;
    }

    public void setSparsityCheckFrequency(long sparsityCheckFreq) {
        A.ensure(sparsityCheckFreq >= 20L, "sparsityCheckFreq >= 20");
        this.sparsityCheckFreq = sparsityCheckFreq;
    }

    public long getFsyncDelay() {
        return this.fsyncDelay;
    }

    public void setFsyncDelay(long fsyncDelay) {
        A.ensure(fsyncDelay >= 0L, "fsyncDelay >= 0");
        this.fsyncDelay = fsyncDelay;
    }

    public long getWriteDelay() {
        return this.writeDelay;
    }

    public void setWriteDelay(long writeDelay) {
        A.ensure(writeDelay >= 0L, "writeDelay >= 0");
        this.writeDelay = writeDelay;
    }

    public CacheFileLocalStoreWriteMode getWriteMode() {
        return this.writeMode;
    }

    public void setWriteMode(CacheFileLocalStoreWriteMode writeMode) {
        A.notNull((Object)writeMode, "writeMode");
        this.writeMode = writeMode;
    }

    public float getMaxSparsity() {
        return this.maxSparsity;
    }

    public void setMaxSparsity(float maxSparsity) {
        A.ensure(maxSparsity > 0.0f && maxSparsity < 1.0f, "maxSparsity > 0 && maxSparsity < 1");
        this.maxSparsity = maxSparsity;
    }

    public long getMinCompactSize() {
        return this.minCompactSize;
    }

    public void setMinCompactSize(long minCompactSize) {
        A.ensure(minCompactSize > 0L, "minCompactSize > 0");
        this.minCompactSize = minCompactSize;
    }

    public boolean isChecksum() {
        return this.checksum;
    }

    public void setChecksum(boolean checksum) {
        this.checksum = checksum;
    }

    public int getMapCapacity() {
        return this.mapCap;
    }

    public void setMapCapacity(int mapCap) {
        A.ensure(U.isPow2(mapCap), "mapCap must be power of 2");
        this.mapCap = mapCap;
    }

    public int getMapSegments() {
        return this.mapSegments;
    }

    public void setMapSegments(int mapSegments) {
        A.ensure(U.isPow2(mapSegments), "mapSegments must be power of 2");
        this.mapSegments = mapSegments;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        A.notNull(rootPath, "rootPath");
        this.rootPath = rootPath;
    }

    public void setUseConsistentId(Boolean useConsistentId) {
        this.useConsistentId = useConsistentId;
    }

    public boolean getUseConsistentId() {
        return this.useConsistentId;
    }

    @Override
    public void start() {
        GridUtils.ensureNoCompactFootersForLocalStore(this.ignite.configuration());
    }

    @Override
    public void stop() {
        try {
            CacheFileLocalStoreFileManager s2 = this.fileManager(false);
            this.stopping = true;
            if (s2 != null) {
                s2.stop();
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    private void checkStopping() throws IgniteCheckedException {
        if (this.stopping) {
            throw new IgniteCheckedException("Local store is stopping.");
        }
    }

    int size() throws IgniteCheckedException {
        return this.fileManager(true).size();
    }

    void clear() throws IgniteCheckedException {
        assert (this.fileManager(false) == null);
        File dir = this.resolveDirectory().toFile();
        X.println("Clearing " + dir + " | " + dir.exists() + " | " + U.delete(dir) + " | " + dir.exists(), new Object[0]);
    }

    @Override
    @Nullable
    public IgniteBiTuple<V, ?> load(K key) {
        try {
            Map<K, Cache.Entry<K, IgniteBiTuple<V, ?>>> cacheDelta;
            Map<String, Map<K, Cache.Entry<K, IgniteBiTuple<V, ?>>>> delta = this.delta(this.transaction(), false);
            if (!F.isEmpty(delta) && (cacheDelta = delta.get(this.cacheName)) != null && cacheDelta.containsKey(key)) {
                return cacheDelta.get(key).getValue();
            }
            return (IgniteBiTuple)this.fileManager(true).load(key);
        }
        catch (IgniteCheckedException e) {
            throw new CacheLoaderException(e);
        }
    }

    @Override
    public void loadCache(IgniteBiInClosure<K, IgniteBiTuple<V, ?>> clo, Object ... args) {
        try {
            this.fileManager(true).loadAll(clo);
        }
        catch (IgniteCheckedException e) {
            throw new CacheLoaderException(e);
        }
    }

    @Override
    public Map<K, IgniteBiTuple<V, ?>> loadAll(Iterable<? extends K> keys) {
        try {
            if (F.isEmpty(keys)) {
                return Collections.emptyMap();
            }
            assert (keys instanceof Collection) : keys.getClass();
            Collection keys0 = (Collection)keys;
            if (keys0.size() == 1) {
                K key = keys.iterator().next();
                Object val = this.load((Object)key);
                if (val != null) {
                    return Collections.singletonMap(key, val);
                }
                return Collections.emptyMap();
            }
            Map<String, Map<K, Cache.Entry<K, IgniteBiTuple<V, ?>>>> delta = this.delta(this.transaction(), false);
            CacheFileLocalStoreFileManager space = this.fileManager(true);
            Map<K, Cache.Entry<K, IgniteBiTuple<Cache.Entry<K, IgniteBiTuple<V, ?>>, ?>>> cacheDelta = F.isEmpty(delta) ? null : delta.get(this.cacheName);
            return space.loadAll(keys0, cacheDelta);
        }
        catch (IgniteCheckedException e) {
            throw new CacheLoaderException(e);
        }
    }

    @Override
    public void write(Cache.Entry<? extends K, ? extends IgniteBiTuple<V, ?>> entry) {
        try {
            Transaction tx = this.transaction();
            Map<String, Map<String, Cache.Entry<String, IgniteBiTuple<HashMap<K, Cache.Entry<K, IgniteBiTuple<V, ?>>>, ?>>>> delta = this.delta(tx, true);
            if (delta == null) {
                assert (tx == null);
                this.fileManager(true).update(entry.getKey(), entry.getValue());
            } else {
                Map<K, Cache.Entry<K, IgniteBiTuple<Cache.Entry<K, IgniteBiTuple<V, ?>>, ?>>> cacheDelta = delta.get(this.cacheName);
                if (cacheDelta == null) {
                    cacheDelta = new HashMap();
                    delta.put(this.cacheName, cacheDelta);
                }
                cacheDelta.put(entry.getKey(), entry);
            }
        }
        catch (IgniteCheckedException e) {
            throw new CacheWriterException(U.convertExceptionNoWrap(e));
        }
    }

    @Override
    public void writeAll(Collection<Cache.Entry<? extends K, ? extends IgniteBiTuple<V, ?>>> entries) {
        try {
            Transaction tx = this.transaction();
            Map<String, Map<String, Cache.Entry<String, IgniteBiTuple<HashMap<K, Cache.Entry<K, IgniteBiTuple<V, ?>>>, ?>>>> delta = this.delta(tx, true);
            if (delta == null) {
                assert (tx == null);
                this.fileManager(true).updateAll(entries, null);
            } else {
                Map cacheDelta = delta.get(this.cacheName);
                if (cacheDelta == null) {
                    cacheDelta = new HashMap();
                    delta.put(this.cacheName, cacheDelta);
                }
                for (Cache.Entry e : entries) {
                    cacheDelta.put(e.getKey(), e);
                }
            }
        }
        catch (IgniteCheckedException e) {
            throw new CacheWriterException(U.convertExceptionNoWrap(e));
        }
    }

    @Override
    public void delete(Object key) {
        try {
            Transaction tx = this.transaction();
            Map<String, Map<String, Cache.Entry<String, IgniteBiTuple<HashMap<K, Cache.Entry<K, IgniteBiTuple<V, ?>>>, ?>>>> delta = this.delta(tx, true);
            if (delta == null) {
                assert (tx == null);
                this.fileManager(true).update(key, null);
            } else {
                Map<Object, Cache.Entry<Object, IgniteBiTuple<CacheEntryImpl<Object, Object>, ?>>> cacheDelta = delta.get(this.cacheName);
                if (cacheDelta == null) {
                    cacheDelta = new HashMap();
                    delta.put(this.cacheName, cacheDelta);
                }
                cacheDelta.put(key, new CacheEntryImpl<Object, Object>(key, null));
            }
        }
        catch (IgniteCheckedException e) {
            throw new CacheWriterException(U.convertExceptionNoWrap(e));
        }
    }

    @Override
    public void deleteAll(Collection<?> keys) {
        try {
            Transaction tx = this.transaction();
            Map<String, Map<String, Cache.Entry<String, IgniteBiTuple<HashMap<K, Cache.Entry<K, IgniteBiTuple<V, ?>>>, ?>>>> delta = this.delta(tx, true);
            if (delta == null) {
                assert (tx == null);
                this.fileManager(true).removeAll(keys);
            } else {
                Map<?, Cache.Entry<?, IgniteBiTuple<CacheEntryImpl<?, Object>, ?>>> cacheDelta = delta.get(this.cacheName);
                if (cacheDelta == null) {
                    cacheDelta = new HashMap();
                    delta.put(this.cacheName, cacheDelta);
                }
                for (Object key : keys) {
                    cacheDelta.put(key, new CacheEntryImpl(key, null));
                }
            }
        }
        catch (IgniteCheckedException e) {
            throw new CacheWriterException(U.convertExceptionNoWrap(e));
        }
    }

    @Override
    public void sessionEnd(boolean commit) {
        try {
            Map cacheDelta;
            Transaction tx = this.transaction();
            if (tx == null) {
                return;
            }
            Map props = this.session().properties();
            Map delta = (Map)props.get(TX_DELTA_META_KEY);
            Map map = cacheDelta = F.isEmpty(delta) ? null : (Map)delta.get(this.cacheName);
            if (cacheDelta != null && commit) {
                CacheFileLocalStoreFileManager s2 = this.fileManager(true);
                s2.updateAll(cacheDelta.values(), tx.xid());
            }
        }
        catch (IgniteCheckedException e) {
            throw new CacheWriterException(U.convertExceptionNoWrap(e));
        }
    }

    @Nullable
    private Map<String, Map<K, Cache.Entry<? extends K, ? extends IgniteBiTuple<V, ?>>>> delta(@Nullable Transaction tx, boolean createIfNone) {
        if (tx == null) {
            return null;
        }
        Map props = this.session().properties();
        HashMap delta = (HashMap)props.get(TX_DELTA_META_KEY);
        if (delta == null && createIfNone) {
            delta = new HashMap();
            HashMap old = props.put(TX_DELTA_META_KEY, delta);
            assert (old == null) : "Concurrent access to single tx data.";
        }
        return delta;
    }

    @Nullable
    CacheFileLocalStoreFileManager fileManager(boolean init) throws IgniteCheckedException {
        this.checkStopping();
        GridAtomicInitializer<CacheFileLocalStoreFileManager> holder = this.space;
        if (holder.succeeded()) {
            return holder.result();
        }
        if (!init) {
            return null;
        }
        return holder.init((Callable<CacheFileLocalStoreFileManager>)new IgniteCallable<CacheFileLocalStoreFileManager>(){
            private static final long serialVersionUID = 0L;

            @Override
            public CacheFileLocalStoreFileManager call() throws IgniteCheckedException {
                try {
                    return new CacheFileLocalStoreFileManager(CacheFileLocalStore.this, CacheFileLocalStore.this.ignite, CacheFileLocalStore.this.log, CacheFileLocalStore.this.cacheName, CacheFileLocalStore.this.resolveDirectory(), CacheFileLocalStore.this.fsyncDelay);
                }
                catch (IOException e) {
                    throw new IgniteCheckedException(e);
                }
            }
        });
    }

    private Path resolveDirectory() throws IgniteCheckedException {
        Path path;
        String igniteName = CacheFileLocalStore.maskName(this.ignite.name());
        String cacheName = CacheFileLocalStore.maskName(this.cacheName);
        String id = "";
        if (this.useConsistentId) {
            id = CacheFileLocalStore.maskName(this.consistentId());
            path = this.root().resolve(igniteName).resolve(id).resolve(CacheFileLocalStore.maskName(cacheName));
        } else {
            path = this.root().resolve(igniteName).resolve(CacheFileLocalStore.maskName(cacheName));
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("CacheFileLocalStore resolved store directory [path=" + path + ", root=" + this.root() + ", igniteName=" + igniteName + ", consistentId=" + id + ", cacheName=" + cacheName + ", useConsistentId=" + this.useConsistentId + ']');
        }
        return path;
    }

    private CacheStoreSession session() {
        return this.ses;
    }

    private static String maskName(@Nullable String name) {
        if (name == null) {
            return U.maskName(name);
        }
        StringBuilder b = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                b.append(c);
                continue;
            }
            b.append('_');
        }
        return b.toString();
    }

    String consistentId() {
        return this.ignite.cluster().localNode().consistentId().toString();
    }

    Path root() throws IgniteCheckedException {
        if (this.root == null) {
            this.root = U.resolveWorkDirectory(this.ignite.configuration().getWorkDirectory(), this.rootPath, false).toPath();
        }
        return this.root;
    }

    @Nullable
    private Transaction transaction() {
        CacheStoreSession ses = this.session();
        return ses != null ? ses.transaction() : null;
    }

    public String toString() {
        return S.toString(CacheFileLocalStore.class, this);
    }
}

