/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.isolated;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpi;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpiInternalListener;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.discovery.DiscoveryMetricsProvider;
import org.apache.ignite.spi.discovery.DiscoveryNotification;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.apache.ignite.spi.discovery.DiscoverySpiDataExchange;
import org.apache.ignite.spi.discovery.DiscoverySpiHistorySupport;
import org.apache.ignite.spi.discovery.DiscoverySpiListener;
import org.apache.ignite.spi.discovery.DiscoverySpiNodeAuthenticator;
import org.apache.ignite.spi.discovery.DiscoverySpiOrderSupport;
import org.apache.ignite.spi.discovery.isolated.IsolatedNode;
import org.jetbrains.annotations.Nullable;

@IgniteSpiMultipleInstancesSupport(value=true)
@DiscoverySpiHistorySupport(value=true)
@DiscoverySpiOrderSupport(value=true)
public class IsolatedDiscoverySpi
extends IgniteSpiAdapter
implements IgniteDiscoverySpi {
    private Serializable consistentId;
    private final long startTime = System.currentTimeMillis();
    private IsolatedNode locNode;
    private DiscoverySpiListener lsnr;
    private ExecutorService exec = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private DiscoverySpiNodeAuthenticator nodeAuth;
    private JdkMarshaller marsh;

    @Override
    public Serializable consistentId() throws IgniteSpiException {
        if (this.consistentId == null) {
            IgniteConfiguration cfg = this.ignite.configuration();
            Serializable cfgId = cfg.getConsistentId();
            this.consistentId = cfgId != null ? cfgId : UUID.randomUUID();
        }
        return this.consistentId;
    }

    @Override
    public Collection<ClusterNode> getRemoteNodes() {
        return Collections.emptyList();
    }

    @Override
    public ClusterNode getLocalNode() {
        return this.locNode;
    }

    @Override
    public ClusterNode getNode(UUID nodeId) {
        return this.locNode.id().equals(nodeId) ? this.locNode : null;
    }

    @Override
    public boolean pingNode(UUID nodeId) {
        return this.locNode.id().equals(nodeId);
    }

    @Override
    public void setNodeAttributes(Map<String, Object> attrs, IgniteProductVersion ver) {
        this.locNode = new IsolatedNode(this.ignite.configuration().getNodeId(), attrs, ver);
    }

    @Override
    public void setListener(@Nullable DiscoverySpiListener lsnr) {
        this.lsnr = lsnr;
    }

    @Override
    public void setDataExchange(DiscoverySpiDataExchange exchange) {
    }

    @Override
    public void setMetricsProvider(DiscoveryMetricsProvider metricsProvider) {
    }

    @Override
    public void disconnect() throws IgniteSpiException {
    }

    @Override
    protected void injectResources(Ignite ignite) {
        super.injectResources(ignite);
        this.marsh = ignite != null && ignite instanceof IgniteKernal ? ((IgniteKernal)ignite).context().marshallerContext().jdkMarshaller() : new JdkMarshaller();
    }

    @Override
    public void setAuthenticator(DiscoverySpiNodeAuthenticator auth) {
        this.nodeAuth = auth;
    }

    @Override
    public long getGridStartTime() {
        return this.startTime;
    }

    @Override
    public void sendCustomEvent(DiscoverySpiCustomMessage msg) throws IgniteException {
        this.exec.execute(() -> {
            IgniteFuture<?> fut = this.lsnr.onDiscovery(new DiscoveryNotification(18, 1L, this.locNode, Collections.singleton(this.locNode), null, msg, null));
            fut.listen(f -> {
                DiscoverySpiCustomMessage ack = msg.ackMessage();
                if (ack != null) {
                    this.exec.execute(() -> this.lsnr.onDiscovery(new DiscoveryNotification(18, 1L, this.locNode, Collections.singleton(this.locNode), null, ack, null)));
                }
            });
        });
    }

    @Override
    public void failNode(UUID nodeId, @Nullable String warning) {
    }

    @Override
    public boolean isClientMode() throws IllegalStateException {
        return false;
    }

    @Override
    public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
        this.authenticateNode();
        this.exec.execute(() -> {
            this.lsnr.onLocalNodeInitialized(this.locNode);
            this.lsnr.onDiscovery(new DiscoveryNotification(10, 1L, this.locNode, Collections.singleton(this.locNode)));
        });
    }

    private void authenticateNode() {
        SecurityCredentials locCred = (SecurityCredentials)this.locNode.attribute("org.apache.ignite.security.cred");
        if (this.nodeAuth != null) {
            SecurityContext subj = this.nodeAuth.authenticateNode(this.locNode, locCred);
            HashMap<String, Object> attrs = new HashMap<String, Object>(this.locNode.attributes());
            try {
                attrs.put("org.apache.ignite.security.subject.v2", U.marshal(this.marsh, (Object)subj));
                attrs.put("org.apache.ignite.security.subject", this.marshalWithSecurityVersion(this.marsh, subj, 1));
            }
            catch (IgniteCheckedException e) {
                throw new IgniteSpiException("Failed to authenticate local node (will shutdown local node).", e);
            }
            this.locNode.setAttributes(attrs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] marshalWithSecurityVersion(Marshaller marsh, Object obj, int ver) throws IgniteCheckedException {
        try {
            SecurityUtils.serializeVersion(ver);
            byte[] byArray = U.marshal(marsh, obj);
            return byArray;
        }
        finally {
            SecurityUtils.restoreDefaultSerializeVersion();
        }
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        this.exec.shutdownNow();
    }

    @Override
    protected void onContextInitialized0(IgniteSpiContext spiCtx) throws IgniteSpiException {
    }

    @Override
    public boolean knownNode(UUID nodeId) {
        return this.getNode(nodeId) != null;
    }

    @Override
    public boolean clientReconnectSupported() {
        return false;
    }

    @Override
    public void clientReconnect() {
    }

    @Override
    public boolean allNodesSupport(IgniteFeatures feature) {
        if (this.locNode == null) {
            return false;
        }
        return IgniteFeatures.allNodesSupports(null, Collections.singleton(this.locNode), feature);
    }

    @Override
    public boolean allNodesSupport(IgniteFeatures feature, IgnitePredicate<ClusterNode> nodesPred) {
        if (this.locNode == null) {
            return false;
        }
        if (!nodesPred.apply(this.locNode)) {
            return false;
        }
        return this.allNodesSupport(feature);
    }

    @Override
    public void simulateNodeFailure() {
    }

    @Override
    public void setInternalListener(IgniteDiscoverySpiInternalListener lsnr) {
    }

    @Override
    public boolean supportsCommunicationFailureResolve() {
        return false;
    }

    @Override
    public void resolveCommunicationFailure(ClusterNode node, Exception err) {
    }
}

