/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.mxbean;

import org.apache.ignite.mxbean.MXBeanDescription;
import org.apache.ignite.mxbean.MXBeanParametersDescriptions;
import org.apache.ignite.mxbean.MXBeanParametersNames;

@MXBeanDescription(value="MBean that provides access IO statistics metrics.")
public interface IoStatisticsMetricsMXBean {
    @MXBeanDescription(value="Start time of gathering staistics.")
    public long getStartTime();

    @MXBeanDescription(value="Start time of gathering staistics.")
    public String getStartTimeLocal();

    @MXBeanDescription(value="Reset gathered statistics.")
    public void reset();

    @MXBeanDescription(value="String presentation of cache group IO statistics.")
    @MXBeanParametersNames(value={"cacheGrpName"})
    @MXBeanParametersDescriptions(value={"Cache group name."})
    public String getCacheGroupStatistics(String var1);

    @MXBeanDescription(value="Number of physical page reads for given cache group.Can return null in case such statistics doesn't exists.")
    @MXBeanParametersNames(value={"cacheGrpName"})
    @MXBeanParametersDescriptions(value={"Cache group name."})
    public Long getCacheGroupPhysicalReads(String var1);

    @MXBeanDescription(value="Number of logical page reads for given cache group. Can return null in case such statistics doesn't exists.")
    @MXBeanParametersNames(value={"cacheGrpName"})
    @MXBeanParametersDescriptions(value={"Cache group name."})
    public Long getCacheGroupLogicalReads(String var1);

    @MXBeanDescription(value="String presentation of index IO statistics.")
    @MXBeanParametersNames(value={"cacheGrpName", "idxName"})
    @MXBeanParametersDescriptions(value={"Cache group name.", "Index name."})
    public String getIndexStatistics(String var1, String var2);

    @MXBeanDescription(value="Number of physical page reads for given cache group.Can return null in case such statistics doesn't exists.")
    @MXBeanParametersNames(value={"cacheGrpName", "idxName"})
    @MXBeanParametersDescriptions(value={"Cache group name.", "Index name."})
    public Long getIndexPhysicalReads(String var1, String var2);

    @MXBeanDescription(value="Number of logical page reads for given cache group.Can return null in case such statistics doesn't exists.")
    @MXBeanParametersNames(value={"cacheGrpName", "idxName"})
    @MXBeanParametersDescriptions(value={"Cache group name.", "Index name."})
    public Long getIndexLogicalReads(String var1, String var2);

    @MXBeanDescription(value="Number of logical leaf index's page reads for given cache group and index.Can return null in case such statistics doesn't exists.")
    @MXBeanParametersNames(value={"cacheGrpName", "idxName"})
    @MXBeanParametersDescriptions(value={"Cache group name.", "Index name."})
    public Long getIndexLeafLogicalReads(String var1, String var2);

    @MXBeanDescription(value="Number of physical leaf index's page reads for given cache group and index.Can return null in case such statistics doesn't exists.")
    @MXBeanParametersNames(value={"cacheGrpName", "idxName"})
    @MXBeanParametersDescriptions(value={"Cache group name.", "Index name."})
    public Long getIndexLeafPhysicalReads(String var1, String var2);

    @MXBeanDescription(value="Number of logical inner index's page reads for given cache group and index.Can return null in case such statistics doesn't exists.")
    @MXBeanParametersNames(value={"cacheGrpName", "idxName"})
    @MXBeanParametersDescriptions(value={"Cache group name.", "Index name."})
    public Long getIndexInnerLogicalReads(String var1, String var2);

    @MXBeanDescription(value="Number of physical inner index's page reads for given cache group and index.Can return null in case such statistics doesn't exists.")
    @MXBeanParametersNames(value={"cacheGrpName", "idxName"})
    @MXBeanParametersDescriptions(value={"Cache group name.", "Index name."})
    public Long getIndexInnerPhysicalReads(String var1, String var2);
}

