/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.verify.CacheFilterEnum;
import org.jetbrains.annotations.NotNull;

public class VisorIdleVerifyTaskArg
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private Set<String> caches;
    private Set<String> excludeCaches;
    private boolean checkCrc;
    private boolean skipZeros;
    private CacheFilterEnum cacheFilterEnum = CacheFilterEnum.DEFAULT;

    public VisorIdleVerifyTaskArg() {
    }

    public VisorIdleVerifyTaskArg(Set<String> caches, Set<String> excludeCaches, boolean skipZeros, CacheFilterEnum cacheFilterEnum, boolean checkCrc) {
        assert (Objects.nonNull((Object)cacheFilterEnum)) : "Cache filter can't be null";
        this.caches = caches;
        this.excludeCaches = excludeCaches;
        this.skipZeros = skipZeros;
        this.checkCrc = checkCrc;
        this.cacheFilterEnum = cacheFilterEnum;
    }

    public VisorIdleVerifyTaskArg(Set<String> caches, boolean checkCrc) {
        this(caches, null, false, CacheFilterEnum.DEFAULT, false);
    }

    public VisorIdleVerifyTaskArg(Set<String> caches) {
        this(caches, null, false, CacheFilterEnum.DEFAULT, false);
    }

    public boolean checkCrc() {
        return this.checkCrc;
    }

    public Set<String> caches() {
        return this.caches;
    }

    public Set<String> excludeCaches() {
        return this.excludeCaches;
    }

    @Override
    public byte getProtocolVersion() {
        return 4;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeCollection(out, this.caches);
        if (this.instanceOfCurrentClass()) {
            U.writeCollection(out, this.excludeCaches);
            out.writeBoolean(this.checkCrc);
            out.writeBoolean(this.skipZeros);
            U.writeEnum(out, this.cacheFilterEnum);
        }
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.caches = U.readSet(in);
        if (this.instanceOfCurrentClass()) {
            if (protoVer >= 2) {
                this.excludeCaches = U.readSet(in);
            }
            if (protoVer >= 3) {
                this.checkCrc = in.readBoolean();
            }
            if (protoVer >= 4) {
                this.skipZeros = in.readBoolean();
                this.cacheFilterEnum = CacheFilterEnum.fromOrdinal(in.readByte());
            }
        }
    }

    protected void excludeCaches(Set<String> excludeCaches) {
        this.excludeCaches = excludeCaches;
    }

    protected void checkCrc(boolean checkCrc) {
        this.checkCrc = checkCrc;
    }

    public boolean skipZeros() {
        return this.skipZeros;
    }

    protected void skipZeros(boolean skipZeros) {
        this.skipZeros = skipZeros;
    }

    protected void cacheFilterEnum(CacheFilterEnum cacheFilterEnum) {
        assert (Objects.nonNull((Object)cacheFilterEnum));
        this.cacheFilterEnum = cacheFilterEnum;
    }

    @NotNull
    public CacheFilterEnum cacheFilterEnum() {
        return this.cacheFilterEnum;
    }

    public String toString() {
        return S.toString(VisorIdleVerifyTaskArg.class, this);
    }

    private boolean instanceOfCurrentClass() {
        return VisorIdleVerifyTaskArg.class == this.getClass();
    }
}

