/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.tx;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.tx.TxVerboseId;
import org.apache.ignite.internal.visor.tx.VisorTxOperation;
import org.apache.ignite.internal.visor.tx.VisorTxProjection;
import org.apache.ignite.internal.visor.tx.VisorTxSortOrder;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public class VisorTxTaskArg
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private VisorTxOperation operation;
    @Nullable
    private Integer limit;
    @Nullable
    private Long minDuration;
    @Nullable
    private Integer minSize;
    @Nullable
    private TransactionState state;
    @Nullable
    private VisorTxProjection proj;
    @Nullable
    private List<String> consistentIds;
    @Nullable
    private String xid;
    @Nullable
    private String lbRegex;
    @Nullable
    private VisorTxSortOrder sortOrder;
    @Nullable
    private TxVerboseId txInfoArg;

    public VisorTxTaskArg() {
    }

    public VisorTxTaskArg(VisorTxOperation operation, @Nullable Integer limit, @Nullable Long minDuration, @Nullable Integer minSize, @Nullable TransactionState state, @Nullable VisorTxProjection proj, @Nullable List<String> consistentIds, @Nullable String xid, @Nullable String lbRegex, @Nullable VisorTxSortOrder sortOrder, @Nullable TxVerboseId txInfoArg) {
        this.operation = operation;
        this.limit = limit;
        this.minDuration = minDuration;
        this.minSize = minSize;
        this.state = state;
        this.proj = proj;
        this.consistentIds = consistentIds;
        this.lbRegex = lbRegex;
        this.xid = xid;
        this.sortOrder = sortOrder;
        this.txInfoArg = txInfoArg;
    }

    public VisorTxOperation getOperation() {
        return this.operation;
    }

    @Nullable
    public Integer getLimit() {
        return this.limit;
    }

    @Nullable
    public Long getMinDuration() {
        return this.minDuration;
    }

    @Nullable
    public Integer getMinSize() {
        return this.minSize;
    }

    @Nullable
    public TransactionState getState() {
        return this.state;
    }

    public VisorTxProjection getProjection() {
        return this.proj;
    }

    @Nullable
    public List<String> getConsistentIds() {
        return this.consistentIds;
    }

    @Nullable
    public String getLabelRegex() {
        return this.lbRegex;
    }

    @Nullable
    public String getXid() {
        return this.xid;
    }

    @Nullable
    public VisorTxSortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Nullable
    public TxVerboseId txInfoArgument() {
        return this.txInfoArg;
    }

    public boolean verboseMode() {
        return this.txInfoArg != null;
    }

    public void txInfoArgument(@Nullable TxVerboseId txInfoArg) {
        this.txInfoArg = txInfoArg;
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeEnum(out, this.operation);
        out.writeInt(this.limit == null ? -1 : this.limit);
        out.writeLong(this.minDuration == null ? -1L : this.minDuration);
        out.writeInt(this.minSize == null ? -1 : this.minSize);
        U.writeEnum(out, this.state);
        U.writeEnum(out, this.proj);
        U.writeCollection(out, this.consistentIds);
        out.writeUTF(this.lbRegex == null ? "" : this.lbRegex);
        out.writeUTF(this.xid == null ? "" : this.xid);
        U.writeEnum(out, this.sortOrder);
        out.writeObject(this.txInfoArg);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.operation = VisorTxOperation.fromOrdinal(in.readByte());
        this.limit = this.fixNull(in.readInt());
        this.minDuration = this.fixNull(in.readLong());
        this.minSize = this.fixNull(in.readInt());
        this.state = TransactionState.fromOrdinal(in.readByte());
        this.proj = VisorTxProjection.fromOrdinal(in.readByte());
        this.consistentIds = U.readList(in);
        this.lbRegex = this.fixNull(in.readUTF());
        this.xid = this.fixNull(in.readUTF());
        this.sortOrder = VisorTxSortOrder.fromOrdinal(in.readByte());
        if (protoVer >= 2) {
            this.txInfoArg = (TxVerboseId)in.readObject();
        }
    }

    private Integer fixNull(int val) {
        return val == -1 ? null : Integer.valueOf(val);
    }

    private Long fixNull(long val) {
        return val == -1L ? null : Long.valueOf(val);
    }

    private String fixNull(String val) {
        return "".equals(val) ? null : val;
    }

    public String toString() {
        return S.toString(VisorTxTaskArg.class, this);
    }
}

