/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.cache.query.QueryMetrics;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorQueryMetrics
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private long minTime;
    private long maxTime;
    private double avgTime;
    private int execs;
    private int fails;

    public VisorQueryMetrics() {
    }

    public VisorQueryMetrics(QueryMetrics m4) {
        this.minTime = m4.minimumTime();
        this.maxTime = m4.maximumTime();
        this.avgTime = m4.averageTime();
        this.execs = m4.executions();
        this.fails = m4.fails();
    }

    public long getMinimumTime() {
        return this.minTime;
    }

    public long getMaximumTime() {
        return this.maxTime;
    }

    public double getAverageTime() {
        return this.avgTime;
    }

    public int getExecutions() {
        return this.execs;
    }

    public int getFailures() {
        return this.fails;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeLong(this.minTime);
        out.writeLong(this.maxTime);
        out.writeDouble(this.avgTime);
        out.writeInt(this.execs);
        out.writeInt(this.fails);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.minTime = in.readLong();
        this.maxTime = in.readLong();
        this.avgTime = in.readDouble();
        this.execs = in.readInt();
        this.fails = in.readInt();
    }

    public String toString() {
        return S.toString(VisorQueryMetrics.class, this);
    }
}

