/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.QueryDetailMetrics;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryDetailMetricsAdapter;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryDetailMetricsKey;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.query.GridQueryIndexing;
import org.apache.ignite.internal.processors.query.QueryHistory;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.query.VisorQueryDetailMetrics;
import org.apache.ignite.internal.visor.query.VisorQueryDetailMetricsCollectorTaskArg;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorQueryHistoryMetricsCollectorTask
extends VisorMultiNodeTask<VisorQueryDetailMetricsCollectorTaskArg, Collection<VisorQueryDetailMetrics>, Collection<? extends QueryDetailMetrics>> {
    private static final long serialVersionUID = 0L;

    protected VisorQueryHistoryMetricsCollectorJob job(VisorQueryDetailMetricsCollectorTaskArg arg) {
        return new VisorQueryHistoryMetricsCollectorJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Collection<VisorQueryDetailMetrics> reduce0(List<ComputeJobResult> results) throws IgniteException {
        HashMap taskRes = new HashMap();
        for (ComputeJobResult computeJobResult : results) {
            if (computeJobResult.getException() != null) {
                throw computeJobResult.getException();
            }
            Collection metrics = (Collection)computeJobResult.getData();
            VisorQueryHistoryMetricsCollectorJob.aggregateMetrics(-1L, taskRes, metrics, false);
        }
        Collection aggMetrics = taskRes.values();
        ArrayList<VisorQueryDetailMetrics> arrayList = new ArrayList<VisorQueryDetailMetrics>(aggMetrics.size());
        for (GridCacheQueryDetailMetricsAdapter m4 : aggMetrics) {
            arrayList.add(new VisorQueryDetailMetrics(m4));
        }
        return arrayList;
    }

    private static class VisorQueryHistoryMetricsCollectorJob
    extends VisorJob<VisorQueryDetailMetricsCollectorTaskArg, Collection<? extends QueryDetailMetrics>> {
        private static final long serialVersionUID = 0L;

        protected VisorQueryHistoryMetricsCollectorJob(@Nullable VisorQueryDetailMetricsCollectorTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        private static void aggregateMetrics(long since, Map<GridCacheQueryDetailMetricsKey, GridCacheQueryDetailMetricsAdapter> res, Collection<GridCacheQueryDetailMetricsAdapter> metrics, boolean collectNotSqlMetrics) {
            for (GridCacheQueryDetailMetricsAdapter m4 : metrics) {
                if (m4.lastStartTime() <= since) continue;
                GridCacheQueryDetailMetricsKey key = m4.key();
                if (collectNotSqlMetrics && (key.getQueryType() == GridCacheQueryType.SQL || key.getQueryType() == GridCacheQueryType.SQL_FIELDS)) continue;
                GridCacheQueryDetailMetricsAdapter aggMetrics = res.get(key);
                res.put(key, aggMetrics == null ? m4 : aggMetrics.aggregate(m4));
            }
        }

        @Override
        protected Collection<? extends QueryDetailMetrics> run(@Nullable VisorQueryDetailMetricsCollectorTaskArg arg) throws IgniteException {
            assert (arg != null);
            GridCacheProcessor cacheProc = this.ignite.context().cache();
            Collection<String> cacheNames = cacheProc.cacheNames();
            HashMap<GridCacheQueryDetailMetricsKey, GridCacheQueryDetailMetricsAdapter> aggMetrics = new HashMap<GridCacheQueryDetailMetricsKey, GridCacheQueryDetailMetricsAdapter>();
            for (String cacheName : cacheNames) {
                IgniteInternalCache cache;
                if (GridCacheUtils.isSystemCache(cacheName) || (cache = cacheProc.cache(cacheName)) == null || !cache.context().started()) continue;
                VisorQueryHistoryMetricsCollectorJob.aggregateMetrics(arg.getSince(), aggMetrics, cache.context().queries().detailMetrics(), true);
            }
            GridQueryIndexing indexing = this.ignite.context().query().getIndexing();
            if (indexing instanceof IgniteH2Indexing) {
                Collection<QueryHistory> metrics = ((IgniteH2Indexing)indexing).runningQueryManager().queryHistoryMetrics().values();
                for (QueryHistory m4 : metrics) {
                    GridCacheQueryDetailMetricsKey key = new GridCacheQueryDetailMetricsKey(GridCacheQueryType.SQL_FIELDS, m4.query());
                    GridCacheQueryDetailMetricsAdapter oldMetrics = (GridCacheQueryDetailMetricsAdapter)aggMetrics.get(key);
                    GridCacheQueryDetailMetricsAdapter total = oldMetrics != null ? new GridCacheQueryDetailMetricsAdapter(GridCacheQueryType.SQL_FIELDS, m4.query(), null, oldMetrics.executions() + (int)m4.executions(), oldMetrics.completions() + (int)(m4.executions() - m4.failures()), oldMetrics.failures() + (int)m4.failures(), Long.min(oldMetrics.minimumTime(), m4.minimumTime()), Long.max(oldMetrics.maximumTime(), m4.maximumTime()), oldMetrics.totalTime(), Long.max(oldMetrics.lastStartTime(), m4.lastStartTime()), key) : new GridCacheQueryDetailMetricsAdapter(GridCacheQueryType.SQL_FIELDS, m4.query(), null, (int)m4.executions(), (int)(m4.executions() - m4.failures()), (int)m4.failures(), m4.minimumTime(), m4.maximumTime(), 0L, m4.lastStartTime(), key);
                    aggMetrics.put(key, total);
                }
            }
            return new ArrayList(aggMetrics.values());
        }

        public String toString() {
            return S.toString(VisorQueryHistoryMetricsCollectorJob.class, this);
        }
    }
}

