/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.cache.query.QueryDetailMetrics;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorQueryDetailMetrics
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String qryType;
    private String qry;
    private String cache;
    private int execs;
    private int completions;
    private int failures;
    private long minTime;
    private long maxTime;
    private double avgTime;
    private long totalTime;
    private long lastStartTime;

    public VisorQueryDetailMetrics() {
    }

    public VisorQueryDetailMetrics(QueryDetailMetrics m4) {
        this.qryType = m4.queryType();
        this.qry = m4.query();
        this.cache = m4.cache();
        this.execs = m4.executions();
        this.completions = m4.completions();
        this.failures = m4.failures();
        this.minTime = m4.minimumTime();
        this.maxTime = m4.maximumTime();
        this.avgTime = m4.averageTime();
        this.totalTime = m4.totalTime();
        this.lastStartTime = m4.lastStartTime();
    }

    public String getQueryType() {
        return this.qryType;
    }

    public String getQuery() {
        return this.qry;
    }

    public String getCache() {
        return this.cache;
    }

    public int getExecutions() {
        return this.execs;
    }

    public int getCompletions() {
        return this.completions;
    }

    public int getFailures() {
        return this.failures;
    }

    public long getMinimumTime() {
        return this.minTime;
    }

    public long getMaximumTime() {
        return this.maxTime;
    }

    public double getAverageTime() {
        return this.avgTime;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public long getLastStartTime() {
        return this.lastStartTime;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.qryType);
        U.writeString(out, this.qry);
        U.writeString(out, this.cache);
        out.writeInt(this.execs);
        out.writeInt(this.completions);
        out.writeInt(this.failures);
        out.writeLong(this.minTime);
        out.writeLong(this.maxTime);
        out.writeDouble(this.avgTime);
        out.writeLong(this.totalTime);
        out.writeLong(this.lastStartTime);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.qryType = U.readString(in);
        this.qry = U.readString(in);
        this.cache = U.readString(in);
        this.execs = in.readInt();
        this.completions = in.readInt();
        this.failures = in.readInt();
        this.minTime = in.readLong();
        this.maxTime = in.readLong();
        this.avgTime = in.readDouble();
        this.totalTime = in.readLong();
        this.lastStartTime = in.readLong();
    }

    public String toString() {
        return S.toString(VisorQueryDetailMetrics.class, this);
    }
}

