/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.dr;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;

public abstract class VisorDrPartitionCountersTask<K, V, J>
extends VisorMultiNodeTask<K, V, J> {
    protected abstract Set<String> getCaches(K var1);

    protected abstract VisorJob<K, J> createJob(K var1, Map<String, Set<Integer>> var2, boolean var3);

    protected abstract V createResult(Map<UUID, Exception> var1, Map<UUID, J> var2);

    @Override
    protected VisorJob<K, J> job(K arg) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<? extends ComputeJob, ClusterNode> map0(List<ClusterNode> subgrid, VisorTaskArgument<K> arg) {
        K argument = arg.getArgument();
        Set<String> caches = this.getCaches(argument);
        if (caches == null || caches.isEmpty()) {
            caches = this.ignite.context().cache().cacheDescriptors().entrySet().stream().filter(e -> ((DynamicCacheDescriptor)e.getValue()).cacheType() == CacheType.USER).map(Map.Entry::getKey).collect(Collectors.toSet());
        }
        caches.forEach(this.ignite::cache);
        HashSet groups = new HashSet();
        List contexts = caches.stream().map(name -> this.ignite.context().cache().cache((String)name).context()).filter(cctx -> groups.add(cctx.groupId())).collect(Collectors.toList());
        HashMap<ClusterNode, Map> nodeCachePartsMap = new HashMap<ClusterNode, Map>();
        for (GridCacheContext cctx2 : contexts) {
            int parts = cctx2.affinity().partitions();
            AffinityAssignment assignment = cctx2.affinity().assignment(cctx2.affinity().affinityTopologyVersion());
            for (int p = 0; p < parts; ++p) {
                Collection<ClusterNode> nodes = this.ignite.cluster().forNodes((Collection<? extends ClusterNode>)assignment.assignment().get(p)).nodes();
                for (ClusterNode node : nodes) {
                    String cache = cctx2.group().cacheOrGroupName();
                    nodeCachePartsMap.computeIfAbsent(node, n -> new HashMap()).computeIfAbsent(cache, c -> new HashSet()).add(p);
                }
            }
        }
        HashMap<VisorJob<K, J>, ClusterNode> map = new HashMap<VisorJob<K, J>, ClusterNode>();
        for (ClusterNode clusterNode : nodeCachePartsMap.keySet()) {
            Map cachePartsMap = (Map)nodeCachePartsMap.get(clusterNode);
            map.put(this.createJob(argument, cachePartsMap, this.debug), clusterNode);
        }
        try {
            if (map.isEmpty()) {
                this.ignite.log().warning("No suitable node found for a task: [task=" + this.getClass().getName() + ", topVer=" + this.ignite.cluster().topologyVersion() + ", subGrid=" + U.toShortString(subgrid) + "]");
            }
            HashMap<VisorJob<K, J>, ClusterNode> hashMap = map;
            return hashMap;
        }
        finally {
            if (this.debug) {
                VisorTaskUtils.logMapped(this.ignite.log(), this.getClass(), map.values());
            }
        }
    }

    @Override
    protected V reduce0(List<ComputeJobResult> results) throws IgniteException {
        HashMap nodeMetricsMap = new HashMap();
        HashMap<UUID, Exception> exceptions = new HashMap<UUID, Exception>();
        for (ComputeJobResult res : results) {
            if (res.getException() != null) {
                exceptions.put(res.getNode().id(), res.getException());
                continue;
            }
            Object metrics = res.getData();
            nodeMetricsMap.put(res.getNode().id(), metrics);
        }
        return this.createResult(exceptions, nodeMetricsMap);
    }
}

