/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.dr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class VisorDrFSTCmdArgs
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private Set<String> caches = Collections.emptySet();
    private long snapshotId = -1L;
    private Set<Byte> dcIds = Collections.emptySet();
    private int action;
    @Nullable
    private IgniteUuid operationId;
    private int senderGroup = 3;
    private String senderGrpName;
    private boolean syncMode;

    public VisorDrFSTCmdArgs() {
    }

    public VisorDrFSTCmdArgs(int action, @Nullable IgniteUuid operationId) {
        this.action = action;
        this.operationId = operationId == null ? IgniteUuid.randomUuid() : operationId;
        this.senderGrpName = "";
    }

    public VisorDrFSTCmdArgs(int action, Set<String> caches, long snapshotId, Set<Byte> dcIds, int senderGroup, String senderGrpName, boolean syncMode) {
        this.action = action;
        this.caches = caches == null ? Collections.emptySet() : caches;
        this.snapshotId = snapshotId;
        this.dcIds = dcIds == null ? Collections.emptySet() : dcIds;
        this.senderGroup = senderGroup;
        this.senderGrpName = senderGrpName == null ? "" : senderGrpName;
        this.syncMode = syncMode;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeInt(this.action);
        IgniteUtils.writeCollection(out, this.caches);
        out.writeLong(this.snapshotId);
        IgniteUtils.writeCollection(out, this.dcIds);
        out.writeInt(this.senderGroup);
        out.writeUTF(this.senderGrpName);
        IgniteUtils.writeGridUuid(out, this.operationId);
        out.writeBoolean(this.syncMode);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.action = in.readInt();
        this.caches = IgniteUtils.readSet(in);
        this.snapshotId = in.readLong();
        this.dcIds = IgniteUtils.readSet(in);
        this.senderGroup = in.readInt();
        this.senderGrpName = in.readUTF();
        this.operationId = IgniteUtils.readGridUuid(in);
        this.syncMode = in.readBoolean();
    }

    public long snapshotId() {
        return this.snapshotId;
    }

    public Set<String> caches() {
        return this.caches;
    }

    public Set<Byte> dcIds() {
        return this.dcIds;
    }

    public int action() {
        return this.action;
    }

    @Nullable
    public IgniteUuid operationId() {
        return this.operationId;
    }

    public int senderGroup() {
        return this.senderGroup;
    }

    public String senderGroupName() {
        return this.senderGrpName;
    }

    public boolean isSyncMode() {
        return this.syncMode;
    }

    public String toString() {
        return S.toString(VisorDrFSTCmdArgs.class, this);
    }
}

