/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.dr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.dr.VisorDrCachePartitionMetrics;
import org.apache.ignite.internal.visor.dr.VisorDrCheckPartitionCountersJobResult;
import org.apache.ignite.internal.visor.dr.VisorDrCheckPartitionCountersTaskArg;
import org.apache.ignite.internal.visor.dr.VisorDrPartitionCountersJob;
import org.jetbrains.annotations.Nullable;

public class VisorDrCheckPartitionCountersJob
extends VisorDrPartitionCountersJob<VisorDrCheckPartitionCountersTaskArg, Collection<VisorDrCheckPartitionCountersJobResult>> {
    private static final long serialVersionUID = 0L;
    protected final Map<String, Set<Integer>> cachesWithPartitions;

    public VisorDrCheckPartitionCountersJob(@Nullable VisorDrCheckPartitionCountersTaskArg arg, boolean debug, Map<String, Set<Integer>> cachesWithPartitions) {
        super(arg, debug);
        this.cachesWithPartitions = cachesWithPartitions;
    }

    @Override
    protected Collection<VisorDrCheckPartitionCountersJobResult> run(@Nullable VisorDrCheckPartitionCountersTaskArg arg) throws IgniteException {
        assert (arg != null);
        int checkFirst = arg.getCheckFirst();
        boolean scanUntilFirstError = arg.isScanUntilFirstError();
        ArrayList<VisorDrCheckPartitionCountersJobResult> metrics = new ArrayList<VisorDrCheckPartitionCountersJobResult>();
        for (Map.Entry<String, Set<Integer>> cachesWithParts : this.cachesWithPartitions.entrySet()) {
            metrics.add(this.calculateForCache(cachesWithParts.getKey(), cachesWithParts.getValue(), checkFirst, scanUntilFirstError));
        }
        return metrics;
    }

    private VisorDrCheckPartitionCountersJobResult calculateForCache(String cache, Set<Integer> parts, int checkFirst, boolean scanUntilFirstError) {
        this.ignite.cache(cache);
        CacheGroupContext grpCtx = this.ignite.context().cache().cacheGroup(CU.cacheId(cache));
        if (grpCtx == null) {
            grpCtx = this.ignite.cachex(cache).context().group();
        }
        int size = 0;
        int entriesProcessed = 0;
        int brokenEntriesFound = 0;
        HashSet<Integer> affectedCaches = new HashSet<Integer>();
        HashSet<Integer> affectedPartitions = new HashSet<Integer>();
        for (Integer part : parts) {
            VisorDrCachePartitionMetrics partMetrics = this.calculateForPartition(grpCtx, cache, part, checkFirst, scanUntilFirstError);
            size = (int)((long)size + partMetrics.getSize());
            entriesProcessed = (int)((long)entriesProcessed + partMetrics.getEntriesProcessed());
            if (partMetrics.getBrokenEntriesFound() <= 0L) continue;
            affectedCaches.addAll(partMetrics.getAffectedCaches());
            affectedPartitions.add(part);
            brokenEntriesFound = (int)((long)brokenEntriesFound + partMetrics.getBrokenEntriesFound());
            if (!scanUntilFirstError) continue;
            break;
        }
        return new VisorDrCheckPartitionCountersJobResult(cache, size, affectedCaches, affectedPartitions, entriesProcessed, brokenEntriesFound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VisorDrCachePartitionMetrics calculateForPartition(CacheGroupContext grpCtx, String cache, int part, int checkFirst, boolean scanUntilFirstError) {
        GridDhtLocalPartition locPart = this.reservePartition(part, grpCtx, cache);
        int entriesProcessed = 0;
        int brokenEntriesFound = 0;
        boolean checkFullCache = checkFirst == -1;
        HashSet<Integer> affectedCaches = new HashSet<Integer>();
        try {
            GridIterator<CacheDataRow> it = grpCtx.offheap().partitionIterator(part, 3);
            HashSet<Long> usedCounters = new HashSet<Long>();
            grpCtx.shared().database().checkpointReadLock();
            try {
                while (it.hasNext()) {
                    if (!checkFullCache && checkFirst-- < 0) {
                    } else {
                        CacheDataRow next = (CacheDataRow)it.next();
                        ++entriesProcessed;
                        if (usedCounters.add(next.version().updateCounter())) continue;
                        ++brokenEntriesFound;
                        affectedCaches.add(next.cacheId());
                        if (!scanUntilFirstError) continue;
                    }
                    break;
                }
            }
            finally {
                grpCtx.shared().database().checkpointReadUnlock();
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        finally {
            locPart.release();
        }
        return new VisorDrCachePartitionMetrics(locPart.fullSize(), affectedCaches, entriesProcessed, brokenEntriesFound);
    }

    public String toString() {
        return S.toString(VisorDrCheckPartitionCountersJob.class, this);
    }
}

