/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache.index;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.cache.index.IndexListInfoContainer;
import org.apache.ignite.internal.visor.cache.index.IndexListTaskArg;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.table.Column;
import org.jetbrains.annotations.Nullable;

@GridInternal
@GridVisorManagementTask
public class IndexListTask
extends VisorOneNodeTask<IndexListTaskArg, Set<IndexListInfoContainer>> {
    private static final long serialVersionUID = 0L;
    public static final String EMPTY_GROUP_NAME = "no_group";

    protected IndexListJob job(IndexListTaskArg arg) {
        return new IndexListJob(arg, this.debug);
    }

    private static class IndexListJob
    extends VisorJob<IndexListTaskArg, Set<IndexListInfoContainer>> {
        private static final long serialVersionUID = 0L;

        protected IndexListJob(@Nullable IndexListTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Set<IndexListInfoContainer> run(@Nullable IndexListTaskArg arg) throws IgniteException {
            if (arg == null) {
                throw new IgniteException("IndexListTaskArg is null");
            }
            Pattern indexesPtrn = this.getPattern(arg.indexesRegEx());
            Pattern groupsPtrn = this.getPattern(arg.groupsRegEx());
            Pattern cachesPtrn = this.getPattern(arg.cachesRegEx());
            HashSet<IndexListInfoContainer> idxInfos = new HashSet<IndexListInfoContainer>();
            GridQueryProcessor qry = this.ignite.context().query();
            IgniteH2Indexing indexing = (IgniteH2Indexing)qry.getIndexing();
            for (GridCacheContext ctx : this.ignite.context().cache().context().cacheContexts()) {
                String cacheName = ctx.name();
                String grpName = ctx.config().getGroupName();
                String grpNameToValidate = grpName == null ? IndexListTask.EMPTY_GROUP_NAME : grpName;
                if (!IndexListJob.isNameValid(groupsPtrn, grpNameToValidate) || !IndexListJob.isNameValid(cachesPtrn, cacheName)) continue;
                for (GridQueryTypeDescriptor type : qry.types(cacheName)) {
                    GridH2Table gridH2Tbl = indexing.schemaManager().dataTable(type.schemaName(), type.tableName());
                    if (gridH2Tbl == null) continue;
                    for (Index idx : gridH2Tbl.getIndexes()) {
                        if (!IndexListJob.isNameValid(indexesPtrn, idx.getName()) || !(idx instanceof H2TreeIndexBase)) continue;
                        idxInfos.add(IndexListJob.constructContainer(ctx, idx));
                    }
                }
            }
            return idxInfos;
        }

        @Nullable
        private Pattern getPattern(String regex) {
            return regex == null ? null : Pattern.compile(regex.toLowerCase());
        }

        private static IndexListInfoContainer constructContainer(GridCacheContext ctx, Index idx) {
            return new IndexListInfoContainer(ctx, idx.getName(), Arrays.stream(idx.getColumns()).map(Column::getName).collect(Collectors.toList()), idx.getTable().getName());
        }

        private static boolean isNameValid(Pattern pattern, String name) {
            if (pattern == null) {
                return true;
            }
            return pattern.matcher(name.toLowerCase()).find();
        }
    }
}

