/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.lang.IgniteInClosureX;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCircularBuffer<T>
implements Iterable<T> {
    private final long sizeMask;
    private final Item<T>[] arr;
    private final AtomicLong idxGen = new AtomicLong();

    public GridCircularBuffer(int size) {
        A.ensure(size > 0, "Size should be greater than 0: " + size);
        A.ensure((size & size - 1) == 0, "Size should be power of two: " + size);
        this.sizeMask = size - 1;
        this.arr = new Item[size];
        for (int i = 0; i < this.arr.length; ++i) {
            this.arr[i] = new Item();
        }
    }

    public Collection<T> items() {
        Item<T> t2;
        T item;
        ArrayList<T> res = new ArrayList<T>(this.arr.length);
        Item<T>[] itemArray = this.arr;
        int n = itemArray.length;
        for (int i = 0; i < n && (item = (t2 = itemArray[i]).item()) != null; ++i) {
            res.add(item);
        }
        return res;
    }

    @Override
    public void forEach(IgniteInClosure<T> c) {
        Item<T> t2;
        T item;
        Item<T>[] itemArray = this.arr;
        int n = itemArray.length;
        for (int i = 0; i < n && (item = (t2 = itemArray[i]).item()) != null; ++i) {
            c.apply(item);
        }
    }

    public T2<T, Long> get(long idx) {
        int idx0 = (int)(idx & this.sizeMask);
        return this.arr[idx0].get();
    }

    @Nullable
    public T add(T t2) throws InterruptedException {
        long idx = this.idxGen.getAndIncrement();
        int idx0 = (int)(idx & this.sizeMask);
        return this.arr[idx0].update(idx, t2, this.arr.length);
    }

    @Nullable
    public T add(T t2, @Nullable IgniteInClosureX<T> c) throws InterruptedException, IgniteCheckedException {
        long idx = this.idxGen.getAndIncrement();
        int idx0 = (int)(idx & this.sizeMask);
        return this.arr[idx0].update(idx, t2, this.arr.length, c);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int i;
            int rest;
            {
                int tail;
                for (tail = (int)GridCircularBuffer.this.sizeMask; tail >= 0 && GridCircularBuffer.this.arr[tail].item == null; --tail) {
                }
                this.rest = tail + 1;
                this.i = (long)this.rest <= GridCircularBuffer.this.sizeMask ? 0 : GridCircularBuffer.this.idxGen.intValue() & (int)GridCircularBuffer.this.sizeMask;
            }

            @Override
            public boolean hasNext() {
                return this.rest > 0;
            }

            @Override
            public T next() {
                if (this.rest <= 0) {
                    throw new NoSuchElementException();
                }
                Object res = GridCircularBuffer.this.arr[this.i++].item;
                if ((long)this.i > GridCircularBuffer.this.sizeMask) {
                    this.i = 0;
                }
                --this.rest;
                return res;
            }
        };
    }

    public String toString() {
        return S.toString(GridCircularBuffer.class, this);
    }

    private static class Item<V> {
        private long idx;
        @GridToStringInclude
        private V item;

        Item() {
        }

        synchronized V item() {
            return this.item;
        }

        @Nullable
        synchronized V update(long newIdx, V newItem, long maxIdxDiff) throws InterruptedException {
            assert (newIdx >= 0L);
            while (newIdx - this.idx > maxIdxDiff) {
                this.wait();
            }
            V old = this.item;
            this.idx = newIdx;
            this.item = newItem;
            this.notifyAll();
            return old;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        synchronized V update(long newIdx, V newItem, long maxIdxDiff, @Nullable IgniteInClosureX<V> c) throws InterruptedException, IgniteCheckedException {
            assert (newIdx >= 0L);
            while (newIdx - this.idx > maxIdxDiff) {
                this.wait();
            }
            this.idx = newIdx;
            try {
                if (c != null && this.item != null) {
                    c.applyx(this.item);
                }
                V old = this.item;
                this.item = newItem;
                V v = old;
                return v;
            }
            finally {
                this.notifyAll();
            }
        }

        synchronized T2<V, Long> get() {
            return new T2<V, Long>(this.item, this.idx);
        }

        public synchronized String toString() {
            return S.toString(Item.class, this, "hash=" + System.identityHashCode(this));
        }
    }
}

