/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public abstract class SSLContextSpiWrapper
extends SSLContextSpi {
    protected final SSLContext sslContextDelegate;

    public SSLContextSpiWrapper(SSLContext sslContextDelegate) {
        this.sslContextDelegate = sslContextDelegate;
    }

    protected abstract void configureSSLEngine(SSLEngine var1);

    protected abstract void configureSocket(Socket var1);

    protected abstract void configureServerSocket(ServerSocket var1);

    @Override
    protected void engineInit(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) throws KeyManagementException {
        this.sslContextDelegate.init(keyManagers, trustManagers, secureRandom);
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        return new SSLSocketFactoryClientAuthWrapper(this.sslContextDelegate.getSocketFactory());
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return new SSLServerSocketFactoryClientAuthWrapper(this.sslContextDelegate.getServerSocketFactory());
    }

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        SSLEngine engine = this.sslContextDelegate.createSSLEngine();
        this.configureSSLEngine(engine);
        return engine;
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String s2, int i) {
        SSLEngine engine = this.sslContextDelegate.createSSLEngine(s2, i);
        this.configureSSLEngine(engine);
        return engine;
    }

    @Override
    protected SSLSessionContext engineGetServerSessionContext() {
        return this.sslContextDelegate.getServerSessionContext();
    }

    @Override
    protected SSLSessionContext engineGetClientSessionContext() {
        return this.sslContextDelegate.getClientSessionContext();
    }

    @Override
    protected SSLParameters engineGetDefaultSSLParameters() {
        return this.sslContextDelegate.getDefaultSSLParameters();
    }

    @Override
    protected SSLParameters engineGetSupportedSSLParameters() {
        return this.sslContextDelegate.getSupportedSSLParameters();
    }

    class SSLServerSocketFactoryClientAuthWrapper
    extends SSLServerSocketFactory {
        private final SSLServerSocketFactory sslServerSocketFactoryDelegate;

        SSLServerSocketFactoryClientAuthWrapper(SSLServerSocketFactory sslServerSocketFactoryDelegate) {
            this.sslServerSocketFactoryDelegate = sslServerSocketFactoryDelegate;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.sslServerSocketFactoryDelegate.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.sslServerSocketFactoryDelegate.getSupportedCipherSuites();
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            ServerSocket serverSocket = this.sslServerSocketFactoryDelegate.createServerSocket(port);
            SSLContextSpiWrapper.this.configureServerSocket(serverSocket);
            return serverSocket;
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog) throws IOException {
            ServerSocket serverSocket = this.sslServerSocketFactoryDelegate.createServerSocket(port, backlog);
            SSLContextSpiWrapper.this.configureServerSocket(serverSocket);
            return serverSocket;
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog, InetAddress locAddr) throws IOException {
            ServerSocket serverSocket = this.sslServerSocketFactoryDelegate.createServerSocket(port, backlog, locAddr);
            SSLContextSpiWrapper.this.configureServerSocket(serverSocket);
            return serverSocket;
        }
    }

    private class SSLSocketFactoryClientAuthWrapper
    extends SSLSocketFactory {
        private final SSLSocketFactory sslSocketFactoryDelegate;

        SSLSocketFactoryClientAuthWrapper(SSLSocketFactory sslSocketFactoryDelegate) {
            this.sslSocketFactoryDelegate = sslSocketFactoryDelegate;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.sslSocketFactoryDelegate.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.sslSocketFactoryDelegate.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket() throws IOException {
            Socket socket = this.sslSocketFactoryDelegate.createSocket();
            SSLContextSpiWrapper.this.configureSocket(socket);
            return socket;
        }

        @Override
        public Socket createSocket(Socket sock, String host, int port, boolean autoClose) throws IOException {
            Socket socket = this.sslSocketFactoryDelegate.createSocket(sock, host, port, autoClose);
            SSLContextSpiWrapper.this.configureSocket(socket);
            return socket;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            Socket socket = this.sslSocketFactoryDelegate.createSocket(host, port);
            SSLContextSpiWrapper.this.configureSocket(socket);
            return socket;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress locAddr, int locPort) throws IOException {
            Socket socket = this.sslSocketFactoryDelegate.createSocket(host, port, locAddr, locPort);
            SSLContextSpiWrapper.this.configureSocket(socket);
            return socket;
        }

        @Override
        public Socket createSocket(InetAddress addr, int port) throws IOException {
            Socket socket = this.sslSocketFactoryDelegate.createSocket(addr, port);
            SSLContextSpiWrapper.this.configureSocket(socket);
            return socket;
        }

        @Override
        public Socket createSocket(InetAddress addr, int port, InetAddress locAddr, int locPort) throws IOException {
            Socket socket = this.sslSocketFactoryDelegate.createSocket(addr, port, locAddr, locPort);
            SSLContextSpiWrapper.this.configureSocket(socket);
            return socket;
        }
    }
}

