/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.service;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.ServiceEvent;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.platform.PlatformNativeException;
import org.apache.ignite.internal.processors.platform.services.PlatformService;
import org.apache.ignite.internal.processors.service.GridServiceMethodNotFoundException;
import org.apache.ignite.internal.processors.service.GridServiceMethodReflectKey;
import org.apache.ignite.internal.processors.service.GridServiceNotFoundException;
import org.apache.ignite.internal.processors.service.GridServiceProcessor;
import org.apache.ignite.internal.processors.service.ServiceCallContextHolder;
import org.apache.ignite.internal.processors.service.ServiceCallContextImpl;
import org.apache.ignite.internal.processors.service.ServiceContextImpl;
import org.apache.ignite.internal.processors.task.GridTaskThreadContextKey;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.platform.PlatformServiceMethod;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceCallContext;
import org.jetbrains.annotations.Nullable;

public class GridServiceProxy<T>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final Method PLATFORM_SERVICE_INVOKE_METHOD;
    private static final Method PLATFORM_SERVICE_INVOKE_METHOD2;
    private static final Method PLATFORM_SERVICE_INVOKE_METHOD3;
    public static final String SUBJECT_ID_KEY = "subjId";
    public static final String REQUEST_ID_KEY = "requestId";
    @GridToStringExclude
    private final IgniteLogger log;
    private final T proxy;
    private final ClusterGroup prj;
    @GridToStringExclude
    private final GridKernalContext ctx;
    private final AtomicReference<ClusterNode> rmtNode = new AtomicReference();
    private boolean hasLocNode;
    private final String name;
    private final boolean sticky;
    private final long waitTimeout;

    public GridServiceProxy(ClusterGroup prj, String name, Class<? super T> svc, boolean sticky, long timeout, GridKernalContext ctx, @Nullable Supplier<ServiceCallContext> callCtxProvider) {
        assert (timeout >= 0L) : timeout;
        this.prj = prj;
        this.ctx = ctx;
        this.name = name;
        this.sticky = sticky;
        this.waitTimeout = timeout;
        this.hasLocNode = this.hasLocalNode(prj);
        this.log = ctx.log(this.getClass());
        this.proxy = Proxy.newProxyInstance(svc.getClassLoader(), new Class[]{svc}, (InvocationHandler)new ProxyInvocationHandler(callCtxProvider));
    }

    private boolean hasLocalNode(ClusterGroup prj) {
        for (ClusterNode n : prj.nodes()) {
            if (!n.isLocal()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invokeMethod(Method mtd, Object[] args, ServiceCallContext callCtx) throws Throwable {
        block23: {
            subjId = null;
            if (callCtx != null && callCtx.attribute("subjId") != null) {
                subjId = UUID.fromString(callCtx.attribute("subjId"));
            }
            requestId = null;
            if (callCtx != null && callCtx.attribute("requestId") != null) {
                requestId = UUID.fromString(callCtx.attribute("requestId"));
            }
            if (U.isHashCodeMethod(mtd)) {
                return this.invokeObjectMethods((Callable<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$invokeMethod$0(), ()Ljava/lang/Object;)((GridServiceProxy)this), "hashCode", subjId, requestId);
            }
            if (U.isEqualsMethod(mtd)) {
                return this.invokeObjectMethods((Callable<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$invokeMethod$1(java.lang.Object[] ), ()Ljava/lang/Object;)((GridServiceProxy)this, (Object[])args), "equals", subjId, requestId);
            }
            if (U.isToStringMethod(mtd)) {
                return this.invokeObjectMethods((Callable<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$invokeMethod$2(), ()Ljava/lang/Object;)((GridServiceProxy)this), "toString", subjId, requestId);
            }
            this.ctx.gateway().readLock();
            try {
                startTime = U.currentTimeMillis();
lbl16:
                // 2 sources

                while (true) {
                    node = null;
                    try {
                        node = this.nodeForService(this.name, this.sticky);
                        if (node == null) {
                            throw new IgniteException("Failed to find deployed service: " + this.name);
                        }
                        if (node.isLocal()) {
                            svcCtx = this.ctx.service().serviceContext(this.name);
                            if (svcCtx == null || (svc = svcCtx.service()) == null) break block23;
                            var11_15 = this.callServiceLocally(svc, mtd, args, callCtx, subjId, requestId);
                        }
                        break;
                    }
                    catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                    catch (Error | RuntimeException e) {
                        throw e;
                    }
                    catch (IgniteCheckedException e) {
                        ignorableCause = X.cause(e, ClusterTopologyCheckedException.class);
                        if (ignorableCause == null && this.ctx.service() instanceof GridServiceProcessor) {
                            ignorableCause = X.cause(e, GridServiceNotFoundException.class);
                        }
                        if (ignorableCause != null) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Service was not found or topology changed (will retry): " + ignorableCause.getMessage());
                            }
                            break block23;
                        }
                        svcProxyE = X.cause(e, ServiceProxyException.class);
                        if (svcProxyE != null) {
                            throw svcProxyE.getCause();
                        }
                        throw U.convertException(e);
                    }
                    catch (Exception e) {
                        throw new IgniteException(e);
                    }
                    this.ctx.gateway().readUnlock();
                    return var11_15;
                }
            }
            catch (Throwable var12_17) {
                this.ctx.gateway().readUnlock();
                throw var12_17;
            }
            {
                this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_IO_POLICY, (byte)11);
                svcCtx = this.ctx.closure().callAsyncNoFailover(GridClosureCallMode.BROADCAST, new ServiceProxyCallable(this.methodName(mtd), this.name, mtd.getParameterTypes(), args, callCtx), Collections.singleton(node), false, this.waitTimeout, true).get();
            }
            this.ctx.gateway().readUnlock();
            return svcCtx;
        }
        this.rmtNode.compareAndSet(node, null);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteException(e);
        }
        ** while (this.waitTimeout <= 0L || U.currentTimeMillis() - startTime < this.waitTimeout)
lbl65:
        // 1 sources

        throw new IgniteException("Service acquire timeout was reached, stopping. [timeout=" + this.waitTimeout + "]");
    }

    private Object invokeObjectMethods(Callable<Object> mtdCall, String mtdName, UUID subjId, UUID requestId) throws Exception {
        Object res;
        try {
            GridServiceProxy.recordServiceEvent(this.ctx, 163, "Service method execution has started.", this.name, mtdName, subjId, requestId);
            res = mtdCall.call();
        }
        catch (Exception ex) {
            GridServiceProxy.recordServiceEvent(this.ctx, 165, "Service method execution failed. " + ex.getMessage(), this.name, mtdName, subjId, requestId);
            throw ex;
        }
        GridServiceProxy.recordServiceEvent(this.ctx, 164, "Service method execution finished.", this.name, mtdName, subjId, requestId);
        return res;
    }

    private Object callServiceLocally(Service svc, Method mtd, Object[] args, @Nullable ServiceCallContext callCtx, UUID subjId, UUID requestId) throws Exception {
        Object res;
        String mtdName = this.methodName(mtd);
        GridServiceProxy.recordServiceEvent(this.ctx, 163, "Service method execution has started.", this.name, mtdName, subjId, requestId);
        try {
            if (svc instanceof PlatformService && !PLATFORM_SERVICE_INVOKE_METHOD.equals(mtd) && !PLATFORM_SERVICE_INVOKE_METHOD2.equals(mtd) && !PLATFORM_SERVICE_INVOKE_METHOD3.equals(mtd)) {
                Map<String, Object> callAttrs = callCtx == null ? null : ((ServiceCallContextImpl)callCtx).values();
                res = ((PlatformService)svc).invokeMethod(mtdName, false, true, args, callAttrs);
            } else {
                res = GridServiceProxy.callServiceMethod(svc, mtd, args, callCtx);
            }
        }
        catch (Exception ex) {
            GridServiceProxy.recordServiceEvent(this.ctx, 165, "Service method execution failed. " + ex.getMessage(), this.name, mtdName, subjId, requestId);
            throw ex;
        }
        GridServiceProxy.recordServiceEvent(this.ctx, 164, "Service method execution finished.", this.name, mtdName, subjId, requestId);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object callServiceMethod(Service svc, Method mtd, Object[] args, @Nullable ServiceCallContext callCtx) throws InvocationTargetException, IllegalAccessException {
        if (callCtx != null) {
            ServiceCallContextHolder.current(callCtx);
        }
        try {
            Object object = mtd.invoke((Object)svc, args);
            return object;
        }
        finally {
            if (callCtx != null) {
                ServiceCallContextHolder.current(null);
            }
        }
    }

    private static void recordServiceEvent(GridKernalContext ctx, int eventType, String msg, String svcName, String mtdName, UUID subjId, UUID requestId) {
        if (ctx.event().isRecordable(eventType)) {
            ServiceEvent event = new ServiceEvent(ctx.discovery().localNode(), msg, eventType, svcName, mtdName, subjId, requestId);
            ctx.event().record(event);
        }
    }

    private ClusterNode nodeForService(String name, boolean sticky) throws IgniteCheckedException {
        while (sticky) {
            ClusterNode curNode = this.rmtNode.get();
            if (curNode != null) {
                return curNode;
            }
            curNode = this.randomNodeForService(name);
            if (curNode == null) {
                return null;
            }
            if (!this.rmtNode.compareAndSet(null, curNode)) continue;
            return curNode;
        }
        return this.randomNodeForService(name);
    }

    private ClusterNode randomNodeForService(String name) throws IgniteCheckedException {
        if (this.hasLocNode && this.ctx.service().service(name) != null) {
            return this.ctx.discovery().localNode();
        }
        Map<UUID, Integer> snapshot = this.ctx.service().serviceTopology(name, this.waitTimeout);
        if (snapshot == null || snapshot.isEmpty()) {
            return null;
        }
        if (snapshot.size() == 1) {
            UUID nodeId = snapshot.keySet().iterator().next();
            return this.prj.node(nodeId);
        }
        Collection<ClusterNode> nodes = this.prj.nodes();
        if (nodes.size() == 1) {
            ClusterNode n = nodes.iterator().next();
            return snapshot.containsKey(n.id()) ? n : null;
        }
        if (this.prj.predicate() == F.alwaysTrue()) {
            int idx = ThreadLocalRandom.current().nextInt(snapshot.size());
            int i = 0;
            for (Map.Entry<UUID, Integer> e : snapshot.entrySet()) {
                if (i++ < idx || e.getValue() <= 0) continue;
                return this.ctx.discovery().node(e.getKey());
            }
            i = 0;
            for (Map.Entry<UUID, Integer> e : snapshot.entrySet()) {
                if (e.getValue() > 0) {
                    return this.ctx.discovery().node(e.getKey());
                }
                if (i++ != idx) continue;
                return null;
            }
        } else {
            ArrayList<ClusterNode> nodeList = new ArrayList<ClusterNode>(nodes.size());
            for (ClusterNode n : nodes) {
                Integer cnt = snapshot.get(n.id());
                if (cnt == null || cnt <= 0) continue;
                nodeList.add(n);
            }
            if (nodeList.isEmpty()) {
                return null;
            }
            int idx = ThreadLocalRandom.current().nextInt(nodeList.size());
            return (ClusterNode)nodeList.get(idx);
        }
        return null;
    }

    T proxy() {
        return this.proxy;
    }

    String methodName(Method mtd) {
        PlatformServiceMethod ann = mtd.getDeclaredAnnotation(PlatformServiceMethod.class);
        return ann == null ? mtd.getName() : ann.value();
    }

    private /* synthetic */ Object lambda$invokeMethod$2() throws Exception {
        return GridServiceProxy.class.getSimpleName() + " [name=" + this.name + ", sticky=" + this.sticky + ']';
    }

    private /* synthetic */ Object lambda$invokeMethod$1(Object[] args) throws Exception {
        return this.proxy == args[0];
    }

    private /* synthetic */ Object lambda$invokeMethod$0() throws Exception {
        return System.identityHashCode(this.proxy);
    }

    static {
        try {
            PLATFORM_SERVICE_INVOKE_METHOD = PlatformService.class.getMethod("invokeMethod", String.class, Boolean.TYPE, Object[].class);
            PLATFORM_SERVICE_INVOKE_METHOD2 = PlatformService.class.getMethod("invokeMethod", String.class, Boolean.TYPE, Boolean.TYPE, Object[].class);
            PLATFORM_SERVICE_INVOKE_METHOD3 = PlatformService.class.getMethod("invokeMethod", String.class, Boolean.TYPE, Boolean.TYPE, Object[].class, Map.class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError("'invokeMethod' is not defined in " + PlatformService.class.getName());
        }
    }

    private static class ServiceProxyException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        ServiceProxyException(Throwable cause) {
            super(cause);
        }
    }

    private static class ServiceProxyCallable
    implements IgniteCallable<Object>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private String mtdName;
        private String svcName;
        private Class<?>[] argTypes;
        private Object[] args;
        private ServiceCallContext callCtx;
        @IgniteInstanceResource
        private transient IgniteEx ignite;

        public ServiceProxyCallable() {
        }

        private ServiceProxyCallable(String mtdName, String svcName, Class<?>[] argTypes, Object[] args, @Nullable ServiceCallContext callCtx) {
            this.mtdName = mtdName;
            this.svcName = svcName;
            this.argTypes = argTypes;
            this.args = args;
            this.callCtx = callCtx;
        }

        @Override
        public Object call() throws Exception {
            Object res;
            ServiceContextImpl ctx = this.ignite.context().service().serviceContext(this.svcName);
            UUID subjId = null;
            if (this.callCtx != null && this.callCtx.attribute(GridServiceProxy.SUBJECT_ID_KEY) != null) {
                subjId = UUID.fromString(this.callCtx.attribute(GridServiceProxy.SUBJECT_ID_KEY));
            }
            UUID requestId = null;
            if (this.callCtx != null && this.callCtx.attribute(GridServiceProxy.REQUEST_ID_KEY) != null) {
                requestId = UUID.fromString(this.callCtx.attribute(GridServiceProxy.REQUEST_ID_KEY));
            }
            GridServiceProxy.recordServiceEvent(this.ignite.context(), 163, "Service method execution has started.", this.svcName, this.mtdName, subjId, requestId);
            if (ctx == null || ctx.service() == null) {
                GridServiceProxy.recordServiceEvent(this.ignite.context(), 165, "Service method execution failed. Service not found: " + this.svcName, this.svcName, this.mtdName, subjId, requestId);
                throw new GridServiceNotFoundException(this.svcName);
            }
            GridServiceMethodReflectKey key = new GridServiceMethodReflectKey(this.mtdName, this.argTypes);
            Method mtd = ctx.method(key);
            try {
                res = ctx.service() instanceof PlatformService && mtd == null ? this.callPlatformService((PlatformService)ctx.service()) : this.callService(ctx.service(), mtd);
            }
            catch (Exception ex) {
                GridServiceProxy.recordServiceEvent(this.ignite.context(), 165, "Service method execution failed. " + ex.getMessage(), this.svcName, this.mtdName, subjId, requestId);
                throw ex;
            }
            GridServiceProxy.recordServiceEvent(this.ignite.context(), 164, "Service method execution finished.", this.svcName, this.mtdName, subjId, requestId);
            return res;
        }

        private Object callPlatformService(PlatformService srv) {
            try {
                return srv.invokeMethod(this.mtdName, false, true, this.args, this.callCtx != null ? ((ServiceCallContextImpl)this.callCtx).values() : null);
            }
            catch (PlatformNativeException ne) {
                throw new ServiceProxyException(U.convertException(ne));
            }
            catch (Exception e) {
                throw new ServiceProxyException(e);
            }
        }

        private Object callService(Service srv, Method mtd) throws Exception {
            if (mtd == null) {
                throw new GridServiceMethodNotFoundException(this.svcName, this.mtdName, this.argTypes);
            }
            try {
                return GridServiceProxy.callServiceMethod(srv, mtd, this.args, this.callCtx);
            }
            catch (InvocationTargetException e) {
                throw new ServiceProxyException(e.getCause());
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString(out, this.svcName);
            U.writeString(out, this.mtdName);
            U.writeArray(out, this.argTypes);
            U.writeArray(out, this.args);
            if (this.callCtx != null) {
                out.writeBoolean(true);
                this.callCtx.writeExternal(out);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.svcName = U.readString(in);
            this.mtdName = U.readString(in);
            this.argTypes = U.readClassArray(in);
            this.args = U.readArray(in);
            try {
                if (in.readBoolean()) {
                    this.callCtx = new ServiceCallContextImpl();
                    this.callCtx.readExternal(in);
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }

        public String toString() {
            return S.toString(ServiceProxyCallable.class, this);
        }
    }

    private class ProxyInvocationHandler
    implements InvocationHandler {
        private final Supplier<ServiceCallContext> callCtxProvider;

        public ProxyInvocationHandler(Supplier<ServiceCallContext> callCtxProvider) {
            this.callCtxProvider = callCtxProvider;
        }

        @Override
        public Object invoke(Object proxy, Method mtd, Object[] args) throws Throwable {
            ServiceCallContext callCtx = this.getCallCtxWithSubjId();
            return GridServiceProxy.this.invokeMethod(mtd, args, callCtx);
        }

        private ServiceCallContext getCallCtxWithSubjId() {
            UUID subjId = GridServiceProxy.this.ctx.security().enabled() ? GridServiceProxy.this.ctx.security().securityContext().subject().id() : GridServiceProxy.this.ctx.localNodeId();
            UUID requestId = UUID.randomUUID();
            if (this.callCtxProvider == null || this.callCtxProvider.get() == null) {
                return ServiceCallContext.builder().put(GridServiceProxy.SUBJECT_ID_KEY, subjId.toString()).put(GridServiceProxy.REQUEST_ID_KEY, requestId.toString()).build();
            }
            ((ServiceCallContextImpl)this.callCtxProvider.get()).values().put(GridServiceProxy.SUBJECT_ID_KEY, subjId.toString());
            ((ServiceCallContextImpl)this.callCtxProvider.get()).values().put(GridServiceProxy.REQUEST_ID_KEY, requestId.toString());
            return this.callCtxProvider.get();
        }
    }
}

