/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.ru;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.processors.ru.RollingUpgradeStatus;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteProductVersion;

public abstract class RollingUpgradeUtil {
    public static List<String> initialNodes(GridKernalContext ctx, RollingUpgradeStatus status) {
        return RollingUpgradeUtil.nodes(ctx, status, status.initialVersion());
    }

    public static List<String> updatedNodes(GridKernalContext ctx, RollingUpgradeStatus status) {
        return RollingUpgradeUtil.nodes(ctx, status, status.targetVersion());
    }

    private static List<String> nodes(GridKernalContext ctx, RollingUpgradeStatus status, IgniteProductVersion ver) {
        if (!status.enabled() || ver == null) {
            return Collections.emptyList();
        }
        DiscoCache disco = ctx.discovery().discoCache();
        return Optional.ofNullable(disco).map(d -> d.allNodes().stream()).orElse(Stream.empty()).filter(n -> n.version().compareToIgnoreTimestamp(ver) == 0).map(n -> U.id8(n.id())).collect(Collectors.toList());
    }
}

