/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat.messages;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.processors.query.stat.StatisticsType;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsColumnData;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsKeyMessage;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class StatisticsObjectData
implements Message {
    private static final long serialVersionUID = 0L;
    public static final short TYPE_CODE = 184;
    private StatisticsKeyMessage key;
    private long rowsCnt;
    private StatisticsType type;
    private int partId;
    private long updCnt;
    @GridDirectMap(keyType=String.class, valueType=StatisticsColumnData.class)
    private Map<String, StatisticsColumnData> data;

    public StatisticsObjectData(StatisticsKeyMessage key, long rowsCnt, StatisticsType type, int partId, long updCnt, Map<String, StatisticsColumnData> data) {
        this.key = key;
        this.rowsCnt = rowsCnt;
        this.type = type;
        this.partId = partId;
        this.updCnt = updCnt;
        this.data = data;
    }

    public StatisticsKeyMessage key() {
        return this.key;
    }

    public long rowsCnt() {
        return this.rowsCnt;
    }

    public StatisticsType type() {
        return this.type;
    }

    public int partId() {
        return this.partId;
    }

    public long updCnt() {
        return this.updCnt;
    }

    public Map<String, StatisticsColumnData> data() {
        return this.data;
    }

    public StatisticsObjectData() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeMap("data", this.data, MessageCollectionItemType.STRING, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeMessage("key", this.key)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeInt("partId", this.partId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeLong("rowsCnt", this.rowsCnt)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeByte("type", this.type != null ? (byte)this.type.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeLong("updCnt", this.updCnt)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.data = reader.readMap("data", MessageCollectionItemType.STRING, MessageCollectionItemType.MSG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.key = (StatisticsKeyMessage)reader.readMessage("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.partId = reader.readInt("partId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.rowsCnt = reader.readLong("rowsCnt");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                byte typeOrd = reader.readByte("type");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.type = StatisticsType.fromOrdinal(typeOrd);
                reader.incrementState();
            }
            case 5: {
                this.updCnt = reader.readLong("updCnt");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(StatisticsObjectData.class);
    }

    @Override
    public short directType() {
        return 184;
    }

    @Override
    public byte fieldsCount() {
        return 6;
    }

    @Override
    public void onAckReceived() {
    }
}

