/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.stat.StatisticsProcessor;
import org.apache.ignite.internal.util.GridBusyLock;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;

public class BusyExecutor {
    private final IgniteLogger log;
    private final String name;
    private volatile boolean active;
    private final GridBusyLock busyLock = new GridBusyLock();
    private final IgniteThreadPoolExecutor pool;

    public BusyExecutor(String name, IgniteThreadPoolExecutor pool, Function<Class<?>, IgniteLogger> logSupplier) {
        this.name = name;
        this.pool = pool;
        this.log = logSupplier.apply(StatisticsProcessor.class);
    }

    public void activate() {
        this.active = true;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Busy executor " + this.name + " activated.");
        }
    }

    public void deactivate(Runnable r) {
        this.active = false;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Busy executor " + this.name + " deactivating.");
        }
        r.run();
        this.busyLock.block();
        this.busyLock.unblock();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Busy executor " + this.name + " deactivated.");
        }
    }

    public boolean busyRun(Runnable r) {
        if (!this.busyLock.enterBusy()) {
            return false;
        }
        try {
            if (!this.active) {
                boolean bl = false;
                return bl;
            }
            r.run();
            boolean bl = true;
            return bl;
        }
        catch (Throwable t2) {
            this.log.warning("Unexpected exception on statistics processing: " + t2.getMessage(), t2);
        }
        finally {
            this.busyLock.leaveBusy();
        }
        return false;
    }

    public CompletableFuture<Boolean> submit(Runnable r) {
        CompletableFuture<Boolean> res = new CompletableFuture<Boolean>();
        this.pool.execute(() -> res.complete(this.busyRun(r)));
        return res;
    }

    public void execute(Runnable r) {
        this.pool.execute(() -> this.busyRun(r));
    }
}

