/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep.msg;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.query.CacheQueryObjectValueContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ValueCacheObject;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessage;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.gridgain.internal.h2.value.Value;

public class GridH2CacheObject
extends GridH2ValueMessage {
    private CacheObject obj;

    public GridH2CacheObject() {
    }

    public GridH2CacheObject(GridH2ValueCacheObject v) throws IgniteCheckedException {
        this.obj = v.getCacheObject();
        this.obj.prepareMarshal(v.valueContext());
    }

    @Override
    public Value value(GridKernalContext ctx) throws IgniteCheckedException {
        CacheQueryObjectValueContext valCtx = ctx.query().objectContext();
        this.obj.finishUnmarshal(valCtx, ctx.cache().context().deploy().globalLoader());
        return new GridH2ValueCacheObject(this.obj, valCtx);
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.obj = (CacheObject)reader.readMessage("obj");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridH2CacheObject.class);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeMessage("obj", this.obj)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public short directType() {
        return -22;
    }

    @Override
    public byte fieldsCount() {
        return 1;
    }

    public String toString() {
        return String.valueOf(this.obj);
    }
}

