/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.cache.CacheException;
import org.apache.ignite.internal.processors.query.h2.twostep.ReduceTable;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.DbObject;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.PlanItem;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.table.TableType;
import org.gridgain.internal.h2.value.Value;

public class ReduceTableWrapper
extends Table {
    private final ThreadLocal<ReduceTable> tbl = new ThreadLocal();

    public ReduceTableWrapper(Schema schema, int id, String name, boolean persistIndexes, boolean persistData) {
        super(schema, id, name, persistIndexes, persistData);
    }

    public void innerTable(ReduceTable t2) {
        if (t2 == null) {
            this.tbl.remove();
        } else {
            this.tbl.set(t2);
        }
    }

    public ReduceTable innerTable() {
        ReduceTable t2 = this.tbl.get();
        if (t2 == null) {
            throw new CacheException("Table `" + this.getName() + "` can be accessed only within Ignite query context.");
        }
        return t2;
    }

    @Override
    public Index getPrimaryKey() {
        return this.innerTable().getPrimaryKey();
    }

    @Override
    public Column getRowIdColumn() {
        return this.innerTable().getRowIdColumn();
    }

    @Override
    public PlanItem getBestPlanItem(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet, boolean isEquiJoined) {
        return this.innerTable().getBestPlanItem(session, masks, filters, filter, sortOrder, allColumnsSet, isEquiJoined);
    }

    @Override
    public Value getDefaultValue(Session session, Column column) {
        return this.innerTable().getDefaultValue(session, column);
    }

    @Override
    public SearchRow getTemplateSimpleRow(boolean singleColumn) {
        return this.innerTable().getTemplateSimpleRow(singleColumn);
    }

    @Override
    public Row getTemplateRow() {
        return this.innerTable().getTemplateRow();
    }

    @Override
    public Column getColumn(String columnName) {
        return this.innerTable().getColumn(columnName);
    }

    @Override
    public Column getColumn(int index) {
        return this.innerTable().getColumn(index);
    }

    @Override
    public Index getIndexForColumn(Column column, boolean needGetFirstOrLast, boolean needFindNext) {
        return this.innerTable().getIndexForColumn(column, needGetFirstOrLast, needFindNext);
    }

    @Override
    public Column[] getColumns() {
        return this.innerTable().getColumns();
    }

    @Override
    protected void setColumns(Column[] columns) {
        throw new IllegalStateException("Cols: " + Arrays.asList(columns));
    }

    @Override
    public boolean lock(Session session, boolean exclusive, boolean force) {
        return this.innerTable().lock(session, exclusive, force);
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session s2) {
        this.innerTable().unlock(s2);
    }

    @Override
    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        return this.innerTable().addIndex(session, indexName, indexId, cols, indexType, create, indexComment);
    }

    @Override
    public void removeRow(Session session, Row row) {
        this.innerTable().removeRow(session, row);
    }

    @Override
    public void truncate(Session session) {
        this.innerTable().truncate(session);
    }

    @Override
    public void addRow(Session session, Row row) {
        this.innerTable().addRow(session, row);
    }

    @Override
    public void checkSupportAlter() {
        this.innerTable().checkSupportAlter();
    }

    @Override
    public TableType getTableType() {
        return TableType.TABLE;
    }

    @Override
    public Index getUniqueIndex() {
        return this.innerTable().getUniqueIndex();
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.innerTable().getScanIndex(session);
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.innerTable().getIndexes();
    }

    @Override
    public boolean isLockedExclusively() {
        return this.innerTable().isLockedExclusively();
    }

    @Override
    public long getMaxDataModificationId() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return this.innerTable().isDeterministic();
    }

    @Override
    public boolean canGetRowCount() {
        return this.innerTable().canGetRowCount();
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public long getRowCount(Session session) {
        return this.innerTable().getRowCount(session);
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        Table t2 = this.tbl.get();
        return t2 == null ? 0L : t2.getRowCountApproximation(ses);
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public String getCreateSQL() {
        return "";
    }

    @Override
    public String getDropSQL() {
        return "";
    }

    @Override
    public void addDependencies(HashSet<DbObject> dependencies) {
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("rename");
    }
}

