/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.ArrayList;
import org.apache.ignite.internal.processors.query.h2.opt.H2ScanIndex;
import org.apache.ignite.internal.processors.query.h2.twostep.AbstractReduceIndexAdapter;
import org.apache.ignite.internal.processors.query.h2.twostep.Reducer;
import org.apache.ignite.internal.util.typedef.F;
import org.gridgain.internal.h2.command.ddl.CreateTableData;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.TableBase;
import org.gridgain.internal.h2.table.TableType;

public class ReduceTable
extends TableBase {
    private ArrayList<Index> idxs;

    public ReduceTable(CreateTableData data) {
        super(data);
    }

    public void indexes(ArrayList<Index> idxs) {
        assert (!F.isEmpty(idxs));
        this.idxs = idxs;
    }

    public Reducer getReducer() {
        Index index = this.idxs.get(this.idxs.size() - 1);
        assert (index instanceof AbstractReduceIndexAdapter) : "Reducer index not found.";
        return ((AbstractReduceIndexAdapter)index).reducer();
    }

    public static H2ScanIndex<AbstractReduceIndexAdapter> createScanIndex(AbstractReduceIndexAdapter idx, ReduceTable tbl) {
        return new H2ScanIndex<AbstractReduceIndexAdapter>(idx, tbl, "_SCAN_" + idx.getName());
    }

    @Override
    public boolean lock(Session session, boolean exclusive, boolean force) {
        return false;
    }

    @Override
    public void close(Session ses) {
    }

    @Override
    public void unlock(Session s2) {
    }

    @Override
    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        throw DbException.getUnsupportedException("addIndex");
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("removeRow");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("truncate");
    }

    @Override
    public void addRow(Session session, Row row) {
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("alter");
    }

    @Override
    public TableType getTableType() {
        return TableType.TABLE;
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.idxs.get(0);
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.idxs;
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public long getMaxDataModificationId() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public long getRowCount(Session ses) {
        return this.getScanIndex(ses).getRowCount(ses);
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        return this.getScanIndex(null).getRowCountApproximation(ses);
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("rename");
    }
}

