/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.CacheException;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.query.h2.twostep.Reducer;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class ReduceQueryRun {
    private final List<Reducer> idxs;
    private CountDownLatch latch;
    private final int pageSize;
    private final Boolean dataPageScanEnabled;
    private final AtomicReference<State> state = new AtomicReference();

    ReduceQueryRun(int idxsCnt, int pageSize, Boolean dataPageScanEnabled) {
        assert (pageSize > 0);
        this.idxs = new ArrayList<Reducer>(idxsCnt);
        this.pageSize = pageSize;
        this.dataPageScanEnabled = dataPageScanEnabled;
    }

    public Boolean isDataPageScanEnabled() {
        return this.dataPageScanEnabled;
    }

    void setStateOnException(@Nullable UUID nodeId, CacheException err) {
        this.setState0(new State(nodeId, err, null, null));
    }

    void setStateOnNodeLeave(UUID nodeId, AffinityTopologyVersion topVer) {
        this.setState0(new State(nodeId, null, topVer, "Data node has left the grid during query execution [nodeId=" + nodeId + ']'));
    }

    void setStateOnRetry(UUID nodeId, AffinityTopologyVersion topVer, String retryCause) {
        assert (!F.isEmpty(retryCause));
        this.setState0(new State(nodeId, null, topVer, retryCause));
    }

    private void setState0(State state) {
        if (!this.state.compareAndSet(null, state)) {
            return;
        }
        while (this.latch.getCount() != 0L) {
            this.latch.countDown();
        }
        for (Reducer idx : this.idxs) {
            idx.onFailure(state.nodeId, state.ex);
        }
    }

    void disconnected(CacheException e) {
        this.setStateOnException(null, e);
    }

    int pageSize() {
        return this.pageSize;
    }

    boolean hasErrorOrRetry() {
        return this.state.get() != null;
    }

    CacheException exception() {
        State st = this.state.get();
        return st != null ? st.ex : null;
    }

    AffinityTopologyVersion retryTopologyVersion() {
        State st = this.state.get();
        return st != null ? st.retryTopVer : null;
    }

    UUID retryNodeId() {
        State st = this.state.get();
        return st != null ? st.nodeId : null;
    }

    String retryCause() {
        State st = this.state.get();
        return st != null ? st.retryCause : null;
    }

    List<Reducer> reducers() {
        return this.idxs;
    }

    void init(int srcSegmentCnt) {
        assert (this.latch == null);
        this.latch = new CountDownLatch(srcSegmentCnt);
    }

    void onFirstPage() {
        this.latch.countDown();
    }

    boolean tryMapToSources(long time, TimeUnit timeUnit) throws IgniteInterruptedCheckedException {
        assert (this.latch != null);
        return U.await(this.latch, time, timeUnit);
    }

    boolean mapped() {
        return this.latch != null && this.latch.getCount() == 0L;
    }

    private static class State {
        private final UUID nodeId;
        private final CacheException ex;
        private final AffinityTopologyVersion retryTopVer;
        private final String retryCause;

        private State(UUID nodeId, CacheException ex, AffinityTopologyVersion retryTopVer, String retryCause) {
            this.nodeId = nodeId;
            this.ex = ex;
            this.retryTopVer = retryTopVer;
            this.retryCause = retryCause;
        }
    }
}

