/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys.view;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractLocalSystemView;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewColumnCondition;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.table.TableType;

public class SqlSystemViewTables
extends SqlAbstractLocalSystemView {
    private static final String TABLE_NAME = "TABLE_NAME";

    public SqlSystemViewTables(GridKernalContext ctx) {
        super("TABLES", "Ignite tables", ctx, TABLE_NAME, SqlSystemViewTables.newColumn("CACHE_GROUP_ID", 4), SqlSystemViewTables.newColumn("CACHE_GROUP_NAME"), SqlSystemViewTables.newColumn("CACHE_ID", 4), SqlSystemViewTables.newColumn("CACHE_NAME"), SqlSystemViewTables.newColumn("SCHEMA_NAME"), SqlSystemViewTables.newColumn(TABLE_NAME), SqlSystemViewTables.newColumn("AFFINITY_KEY_COLUMN"), SqlSystemViewTables.newColumn("KEY_ALIAS"), SqlSystemViewTables.newColumn("VALUE_ALIAS"), SqlSystemViewTables.newColumn("KEY_TYPE_NAME"), SqlSystemViewTables.newColumn("VALUE_TYPE_NAME"));
    }

    @Override
    public Iterator<Row> getRows(Session ses, SearchRow first, SearchRow last) {
        SqlSystemViewColumnCondition nameCond = this.conditionForColumn(TABLE_NAME, first, last);
        String tblNamePtrn = nameCond.isEquality() ? nameCond.valueForEquality().getString() : null;
        List rows = this.ctx.query().getIndexing().tablesInformation(null, tblNamePtrn, TableType.TABLE.name()).stream().map(tbl -> this.createRow(ses, tbl.cacheGrpId(), tbl.cacheGrpName(), tbl.cacheId(), tbl.cacheName(), tbl.schemaName(), tbl.tableName(), tbl.affinityKeyColumn(), tbl.keyAlias(), tbl.valueAlias(), tbl.keyTypeName(), tbl.valueTypeName())).collect(Collectors.toList());
        return rows.iterator();
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public long getRowCount() {
        return this.ctx.query().getIndexing().tablesInformation(null, null, TableType.TABLE.name()).size();
    }
}

