/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys;

import java.util.Iterator;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Cursor;
import org.apache.ignite.internal.processors.query.h2.sys.SystemViewH2Adapter;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.BaseIndex;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.TableFilter;

public class SqlSystemIndex
extends BaseIndex {
    private static final int DISTRIBUTED_MUL = 100;

    SqlSystemIndex(SystemViewH2Adapter tbl, Column ... col) {
        super(tbl, 0, null, col != null && col.length > 0 ? IndexColumn.wrap(col) : H2Utils.EMPTY_COLUMNS, IndexType.createNonUnique(false));
    }

    @Override
    public void close(Session ses) {
    }

    @Override
    public void add(Session ses, Row row) {
        throw DbException.getUnsupportedException("system view is read-only");
    }

    @Override
    public void remove(Session ses, Row row) {
        throw DbException.getUnsupportedException("system view is read-only");
    }

    @Override
    public Cursor find(Session ses, SearchRow first, SearchRow last) {
        assert (this.table instanceof SystemViewH2Adapter);
        Iterator<Row> rows = ((SystemViewH2Adapter)this.table).getRows(ses, first, last);
        return new GridH2Cursor(rows);
    }

    @Override
    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColsSet) {
        double colsCost = this.getRowCountApproximation(ses);
        if (masks != null) {
            for (Column col : this.columns) {
                if ((masks[col.getColumnId()] & 1) == 0) continue;
                colsCost /= 2.0;
            }
        }
        double idxCost = 1000.0 + colsCost;
        if (((SystemViewH2Adapter)this.table).view.isDistributed()) {
            idxCost *= 100.0;
        }
        return idxCost;
    }

    @Override
    public void truncate(Session ses) {
        throw DbException.getUnsupportedException("system view cannot be truncated");
    }

    @Override
    public void remove(Session ses) {
        throw DbException.getUnsupportedException("system view cannot be removed");
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("system view cannot be renamed");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session ses, boolean first) {
        throw DbException.getUnsupportedException("system views cannot be used to get first or last value");
    }

    @Override
    public long getRowCount(Session ses) {
        return this.table.getRowCount(ses);
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        return this.table.getRowCountApproximation(ses);
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }
}

