/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt.join;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.query.h2.opt.join.SourceKey;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class DistributedJoinContext {
    private final AffinityTopologyVersion topVer;
    private final Map<UUID, int[]> partsMap;
    private final UUID originNodeId;
    private final long qryId;
    private final int segment;
    private final int pageSize;
    private Map<Integer, Object> streams;
    private Map<SourceKey, Object> sources;
    private int batchLookupIdGen;
    private UUID[] partsNodes;
    private volatile boolean cancelled;

    public DistributedJoinContext(AffinityTopologyVersion topVer, Map<UUID, int[]> partsMap, UUID originNodeId, long qryId, int segment, int pageSize) {
        this.topVer = topVer;
        this.partsMap = partsMap;
        this.originNodeId = originNodeId;
        this.qryId = qryId;
        this.segment = segment;
        this.pageSize = pageSize;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public Map<UUID, int[]> partitionsMap() {
        return this.partsMap;
    }

    public UUID originNodeId() {
        return this.originNodeId;
    }

    public long queryId() {
        return this.qryId;
    }

    public int segment() {
        return this.segment;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public UUID nodeForPartition(int p, GridCacheContext<?, ?> cctx) {
        UUID[] nodeIds = this.partsNodes;
        if (nodeIds == null) {
            assert (this.partsMap != null);
            nodeIds = new UUID[cctx.affinity().partitions()];
            for (Map.Entry<UUID, int[]> e : this.partsMap.entrySet()) {
                UUID nodeId = e.getKey();
                int[] nodeParts = e.getValue();
                assert (nodeId != null);
                assert (!F.isEmpty(nodeParts));
                for (int part : nodeParts) {
                    assert (nodeIds[part] == null);
                    nodeIds[part] = nodeId;
                }
            }
            this.partsNodes = nodeIds;
        }
        return nodeIds[p];
    }

    public synchronized void putStreams(int batchLookupId, Object streams) {
        if (this.streams == null) {
            if (streams == null) {
                return;
            }
            this.streams = new HashMap<Integer, Object>();
        }
        if (streams == null) {
            this.streams.remove(batchLookupId);
        } else {
            this.streams.put(batchLookupId, streams);
        }
    }

    public synchronized <T> T getStreams(int batchLookupId) {
        if (this.streams == null) {
            return null;
        }
        return (T)this.streams.get(batchLookupId);
    }

    public synchronized void putSource(UUID ownerId, int segmentId, int batchLookupId, Object src) {
        SourceKey srcKey = new SourceKey(ownerId, segmentId, batchLookupId);
        if (src != null) {
            if (this.sources == null) {
                this.sources = new HashMap<SourceKey, Object>();
            }
            this.sources.put(srcKey, src);
        } else if (this.sources != null) {
            this.sources.remove(srcKey);
        }
    }

    public synchronized <T> T getSource(UUID ownerId, int segmentId, int batchLookupId) {
        if (this.sources == null) {
            return null;
        }
        return (T)this.sources.get(new SourceKey(ownerId, segmentId, batchLookupId));
    }

    public int nextBatchLookupId() {
        return ++this.batchLookupIdGen;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public String toString() {
        return S.toString(DistributedJoinContext.class, this);
    }
}

