/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import org.apache.ignite.internal.processors.cache.tree.CacheDataTree;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.H2ScanIndex;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.TableFilter;
import org.jetbrains.annotations.Nullable;

public class H2TableScanIndex
extends H2ScanIndex<GridH2IndexBase> {
    public static final String SCAN_INDEX_NAME_SUFFIX = "__SCAN_";
    private final GridH2Table tbl;
    private final GridH2IndexBase hashIdx;

    H2TableScanIndex(GridH2Table tbl, GridH2IndexBase treeIdx, @Nullable GridH2IndexBase hashIdx) {
        super(treeIdx, tbl, "_SCAN_" + treeIdx.getName());
        this.tbl = tbl;
        this.hashIdx = hashIdx;
    }

    @Override
    protected GridH2IndexBase delegate() {
        boolean rebuildFromHashInProgress = this.tbl.rebuildFromHashInProgress();
        if (this.hashIdx != null) {
            return rebuildFromHashInProgress || CacheDataTree.isDataPageScanEnabled() ? this.hashIdx : (GridH2IndexBase)super.delegate();
        }
        assert (!rebuildFromHashInProgress);
        return (GridH2IndexBase)super.delegate();
    }

    @Override
    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        double baseCost = super.getCost(ses, masks, filters, filter, sortOrder, allColumnsSet);
        int mul = this.delegate().getDistributedMultiplier(ses, filters, filter);
        return (double)mul * baseCost;
    }

    @Override
    public String getPlanSQL() {
        return this.delegate().getTable().getSQL(false) + "." + SCAN_INDEX_NAME_SUFFIX;
    }

    @Override
    public String getName() {
        return this.delegate().getName() + SCAN_INDEX_NAME_SUFFIX;
    }
}

